/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.PropertyModifierIntLinearAdditive;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class OreScannerModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_ORE_SCANNER = "Ore Scanner";
    public static final String ORE_SCANNER_ENERGY_CONSUMPTION = "Energy Per Block";
    public static final String ORE_SCANNER_RADIUS_X = "X Radius";
    public static final String ORE_SCANNER_RADIUS_Y = "Y Radius";
    public static final String ORE_SCANNER_RADIUS_Z = "Z Radius";
    private static Map<Map<ResourceLocation, Integer>, Integer> oreValuemap = new HashMap<Map<ResourceLocation, Integer>, Integer>();
    private static final ArrayList<List<ItemStack>> ores = new ArrayList();
    private static final HashMap<List, String> oreMap = new HashMap();
    private static final HashMap<String, Integer> valueMap = new HashMap();

    public OreScannerModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(ORE_SCANNER_ENERGY_CONSUMPTION, 50.0);
        this.addBaseProperty(ORE_SCANNER_RADIUS_X, 1.0);
        this.addBaseProperty(ORE_SCANNER_RADIUS_Y, 1.0);
        this.addBaseProperty(ORE_SCANNER_RADIUS_Z, 1.0);
        this.addIntTradeoffProperty(ORE_SCANNER_RADIUS_X, ORE_SCANNER_RADIUS_X, 3.0, "m", 1, 0);
        this.addIntTradeoffProperty(ORE_SCANNER_RADIUS_Y, ORE_SCANNER_RADIUS_Y, 3.0, "m", 1, 0);
        this.addIntTradeoffProperty(ORE_SCANNER_RADIUS_Z, ORE_SCANNER_RADIUS_Z, 3.0, "m", 1, 0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.computerChip, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 2));
    }

    public PowerModuleBase addIntTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit, int roundTo, int offset) {
        units.put(propertyName, unit);
        return this.addPropertyModifier(propertyName, new PropertyModifierIntLinearAdditive(tradeoffName, multiplier, roundTo, offset));
    }

    public void betterSearchForValuables(ItemStack itemStack, EntityPlayer player, World world) {
        int xRadius = (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_X);
        int yRadius = (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_Y);
        int zRadius = (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_Z);
        BlockPos pos = player.func_180425_c();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int totalValue = 0;
        int totalEnergy = 0;
        int highestValue = 0;
        String highestvalueblockname = "";
        for (int sX = x - xRadius; sX <= x + xRadius; ++sX) {
            for (int sY = y - yRadius; sY <= y + yRadius; ++sY) {
                for (int sZ = z - zRadius; sZ <= z + zRadius; ++sZ) {
                    BlockPos newpos = new BlockPos(sX, sY, sZ);
                    IBlockState state = world.func_180495_p(newpos);
                    Integer value = OreScannerModule.getValue(state);
                    totalValue += value.intValue();
                    ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_ENERGY_CONSUMPTION));
                    totalEnergy = (int)((double)totalEnergy + ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_ENERGY_CONSUMPTION));
                    if (value <= highestValue) continue;
                    highestValue = value;
                    Block block = state.func_177230_c();
                    ItemStack stack = block.getPickBlock(state, null, world, newpos, player);
                    try {
                        highestvalueblockname = stack.func_82833_r();
                        continue;
                    }
                    catch (Exception e) {
                        highestvalueblockname = block.func_149739_a();
                    }
                }
            }
        }
        if (ElectricItemUtils.getPlayerEnergy(player) > (double)totalEnergy) {
            ElectricItemUtils.drainPlayerEnergy(player, totalEnergy);
            if (MuseItemUtils.isServerSide()) {
                if (highestvalueblockname.isEmpty()) {
                    highestvalueblockname = "None";
                }
                if (Config.useAdvancedOreScannerMessage()) {
                    player.func_145747_a((ITextComponent)new TextComponentString("[Ore Scanner] Total ore value: " + totalValue + " --- Most valuable: " + highestvalueblockname + "\nSearch radius: " + (2 * (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_X) + 1) + "x" + (2 * (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_Y) + 1) + "x" + (2 * (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_Z) + 1) + " --- Energy used: " + MuseStringUtils.formatNumberFromUnits(totalEnergy, "J")));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("[Ore Scanner] Total ore value: " + totalValue + " --- Most valuable: " + highestvalueblockname));
                }
            }
        }
    }

    public static int getValue(IBlockState state) {
        try {
            Block block = state.func_177230_c();
            if (block == Blocks.field_150350_a || block == Blocks.field_150348_b) {
                return 0;
            }
            if (oreValuemap.isEmpty()) {
                oreValuemap = Config.getOreValues();
            }
            int meta = block.func_176201_c(state);
            HashMap<ResourceLocation, Integer> regNameMeta = new HashMap<ResourceLocation, Integer>();
            regNameMeta.put(block.getRegistryName(), meta);
            Integer value = oreValuemap.get(regNameMeta);
            if (value == null) {
                value = 0;
            }
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_ORE_SCANNER;
    }

    @Override
    public String getUnlocalizedName() {
        return "oreScanner";
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        this.betterSearchForValuables(itemStackIn, playerIn, worldIn);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.oreScanner;
    }
}

