/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.tool.ToolHelpers;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PickaxeModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_PICKAXE = "Pickaxe";
    public static final String PICKAXE_HARVEST_SPEED = "Pickaxe Harvest Speed";
    public static final String PICKAXE_ENERGY_CONSUMPTION = "Pickaxe Energy Consumption";
    protected static final ItemStack emulatedTool = new ItemStack(Items.field_151035_b);

    public PickaxeModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Items.field_151042_j, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(PICKAXE_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(PICKAXE_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", PICKAXE_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", PICKAXE_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_PICKAXE;
    }

    @Override
    public String getUnlocalizedName() {
        return "pickaxe";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, IBlockState state, EntityPlayer player) {
        return ToolHelpers.isEffectiveTool(state, emulatedTool) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, PICKAXE_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (ForgeHooks.canToolHarvestBlock((IBlockAccess)worldIn, (BlockPos)pos, (ItemStack)emulatedTool)) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)entityLiving, ModuleManager.computeModularProperty(stack, PICKAXE_ENERGY_CONSUMPTION));
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.setNewSpeed((float)((double)event.getNewSpeed() * ModuleManager.computeModularProperty(event.getEntityPlayer().field_71071_by.func_70448_g(), PICKAXE_HARVEST_SPEED)));
    }

    @Override
    public ItemStack getEmulatedTool() {
        return emulatedTool;
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.pickaxe;
    }
}

