/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import java.util.Random;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.tool.ToolHelpers;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ShearsModule
extends PowerModuleBase
implements IBlockBreakingModule,
IRightClickModule {
    private static final ItemStack emulatedTool = new ItemStack((Item)Items.field_151097_aZ);
    public static final String MODULE_SHEARS = "Shears";
    private static final String SHEARING_ENERGY_CONSUMPTION = "Shearing Energy Consumption";
    private static final String SHEARING_HARVEST_SPEED = "Shearing Harvest Speed";

    public ShearsModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Items.field_151042_j, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(SHEARING_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(SHEARING_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", SHEARING_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", SHEARING_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_SHEARS;
    }

    @Override
    public String getUnlocalizedName() {
        return "shears";
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        Entity entity;
        IShearable target;
        if (playerIn.field_70170_p.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
        }
        RayTraceResult rayTraceResult = MusePlayerUtils.raytraceEntities(worldIn, playerIn, false, 8.0);
        if (rayTraceResult != null && rayTraceResult.field_72308_g instanceof IShearable && (target = (IShearable)rayTraceResult.field_72308_g).isShearable(itemStackIn, (IBlockAccess)entity.field_70170_p, new BlockPos(entity = rayTraceResult.field_72308_g))) {
            List drops = target.onSheared(itemStackIn, (IBlockAccess)entity.field_70170_p, new BlockPos(entity), EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (ItemStack)itemStackIn));
            Random rand = new Random();
            for (ItemStack drop : drops) {
                EntityItem ent = entity.func_70099_a(drop, 1.0f);
                ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
            }
            ElectricItemUtils.drainPlayerEnergy(playerIn, ModuleManager.computeModularProperty(itemStackIn, SHEARING_ENERGY_CONSUMPTION));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, IBlockState state, EntityPlayer player) {
        return ToolHelpers.isEffectiveTool(state, emulatedTool) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, SHEARING_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemStack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        IShearable target;
        if (entityLiving.field_70170_p.field_72995_K) {
            return false;
        }
        Block block = state.func_177230_c();
        if (block instanceof IShearable && ElectricItemUtils.getPlayerEnergy((EntityPlayer)entityLiving) > ModuleManager.computeModularProperty(itemStack, SHEARING_ENERGY_CONSUMPTION) && (target = (IShearable)block).isShearable(itemStack, (IBlockAccess)entityLiving.field_70170_p, pos)) {
            List drops = target.onSheared(itemStack, (IBlockAccess)entityLiving.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(entityLiving.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                entityitem.field_70170_p.func_72838_d((Entity)entityitem);
            }
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)entityLiving, ModuleManager.computeModularProperty(itemStack, SHEARING_ENERGY_CONSUMPTION));
            ((EntityPlayer)entityLiving).func_71064_a(StatList.func_188055_a((Block)block), 1);
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        float defaultEffectiveness = 8.0f;
        double ourEffectiveness = ModuleManager.computeModularProperty(event.getEntityPlayer().field_71071_by.func_70448_g(), SHEARING_HARVEST_SPEED);
        event.setNewSpeed((float)((double)event.getNewSpeed() * Math.max((double)defaultEffectiveness, ourEffectiveness)));
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(emulatedTool).func_177554_e();
    }

    @Override
    public ItemStack getEmulatedTool() {
        return emulatedTool;
    }
}

