/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import appeng.api.AEApi;
import appeng.api.config.LevelEmitterMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.StorageFilter;
import appeng.api.config.ViewItems;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.util.IConfigManager;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.machinemuse.powersuits.common.ModCompatibility;
import net.machinemuse.utils.ElectricItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="extracells.api.IWirelessFluidTermHandler", modid="extracells", striprefs=true), @Optional.Interface(iface="appeng.api.features.IWirelessTermHandler", modid="appliedenergistics2", striprefs=true)})
public class TerminalHandler
implements IWirelessTermHandler {
    @Optional.Method(modid="appliedenergistics2")
    public boolean canHandle(ItemStack is) {
        if (is == null) {
            return false;
        }
        if (is.func_77977_a() == null) {
            return false;
        }
        return is.func_77977_a().equals("item.powerFist");
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean usePower(EntityPlayer entityPlayer, double v, ItemStack itemStack) {
        boolean ret = false;
        if (v * ModCompatibility.getAE2Ratio() < ElectricItemUtils.getPlayerEnergy(entityPlayer) * ModCompatibility.getAE2Ratio()) {
            ElectricItemUtils.drainPlayerEnergy(entityPlayer, v * ModCompatibility.getAE2Ratio());
            ret = true;
        }
        return ret;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean hasPower(EntityPlayer entityPlayer, double v, ItemStack itemStack) {
        return v * ModCompatibility.getAE2Ratio() < ElectricItemUtils.getPlayerEnergy(entityPlayer) * ModCompatibility.getAE2Ratio();
    }

    @Optional.Method(modid="appliedenergistics2")
    public IConfigManager getConfigManager(ItemStack itemStack) {
        WirelessConfig config = new WirelessConfig(itemStack);
        config.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        config.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        config.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        config.readFromNBT(itemStack.func_77978_p());
        return config;
    }

    @Optional.Method(modid="appliedenergistics2")
    public String getEncryptionKey(ItemStack item) {
        if (item == null) {
            return null;
        }
        NBTTagCompound tag = TerminalHandler.openNbtData(item);
        if (tag != null) {
            return tag.func_74779_i("encKey");
        }
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        if (item == null) {
            return;
        }
        NBTTagCompound tag = TerminalHandler.openNbtData(item);
        if (tag != null) {
            tag.func_74778_a("encKey", encKey);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerAEHandler(TerminalHandler handler) {
        AEApi.instance().registries().wireless().registerWirelessHandler((IWirelessTermHandler)handler);
    }

    public static void registerHandler() {
        if (ModCompatibility.isAppengLoaded()) {
            TerminalHandler handler = new TerminalHandler();
            TerminalHandler.registerAEHandler(handler);
        }
    }

    public static NBTTagCompound openNbtData(ItemStack item) {
        NBTTagCompound compound = item.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            item.func_77982_d(compound);
        }
        return compound;
    }

    @Optional.Interface(iface="appeng.api.util.IConfigManager", modid="appliedenergistics2", striprefs=true)
    class WirelessConfig
    implements IConfigManager {
        private final Map<Settings, Enum<?>> enums = new EnumMap(Settings.class);
        final ItemStack stack;

        public WirelessConfig(ItemStack itemStack) {
            this.stack = itemStack;
        }

        @Optional.Method(modid="appliedenergistics2")
        public Enum<?> getSetting(Settings arg0) {
            if (this.enums.containsKey(arg0)) {
                return this.enums.get(arg0);
            }
            return null;
        }

        @Optional.Method(modid="appliedenergistics2")
        public Set<Settings> getSettings() {
            return this.enums.keySet();
        }

        @Optional.Method(modid="appliedenergistics2")
        public Enum putSetting(Settings arg0, Enum arg1) {
            this.enums.put(arg0, arg1);
            this.writeToNBT(this.stack.func_77978_p());
            return arg1;
        }

        @Optional.Method(modid="appliedenergistics2")
        public void registerSetting(Settings arg0, Enum arg1) {
            if (!this.enums.containsKey(arg0)) {
                this.putSetting(arg0, arg1);
            }
        }

        @Optional.Method(modid="appliedenergistics2")
        public void readFromNBT(NBTTagCompound tagCompound) {
            NBTTagCompound tag = null;
            if (tagCompound.func_74764_b("configWirelessTerminal")) {
                tag = tagCompound.func_74775_l("configWirelessTerminal");
            }
            if (tag == null) {
                return;
            }
            for (Settings key : this.enums.keySet()) {
                try {
                    if (!tag.func_74764_b(key.name())) continue;
                    String value = tag.func_74779_i(key.name());
                    if (value.equals("EXTACTABLE_ONLY")) {
                        value = StorageFilter.EXTRACTABLE_ONLY.toString();
                    } else if (value.equals("STOREABLE_AMOUNT")) {
                        value = LevelEmitterMode.STORABLE_AMOUNT.toString();
                    }
                    Enum<?> oldValue = this.enums.get(key);
                    Object newValue = Enum.valueOf(oldValue.getClass(), value);
                    this.putSetting(key, (Enum)newValue);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }

        @Optional.Method(modid="appliedenergistics2")
        public void writeToNBT(NBTTagCompound tagCompound) {
            NBTTagCompound tag = new NBTTagCompound();
            if (tagCompound.func_74764_b("configWirelessTerminal")) {
                tag = tagCompound.func_74775_l("configWirelessTerminal");
            }
            for (Enum enum_ : this.enums.keySet()) {
                tag.func_74778_a(enum_.name(), this.enums.get(enum_).toString());
            }
            tagCompound.func_74782_a("configWirelessTerminal", (NBTBase)tag);
        }
    }
}

