/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class ToolHelpers {
    public static boolean canHarvestBlock(ItemStack stack, IBlockState state, EntityPlayer player) {
        String tool = state.func_177230_c().getHarvestTool(state);
        if (stack == null || tool == null) {
            return false;
        }
        return stack.func_77973_b().getHarvestLevel(stack, tool, null, null) >= state.func_177230_c().getHarvestLevel(state);
    }

    public static boolean isEffectiveTool(IBlockState state, ItemStack emulatedTool) {
        String effectiveTool = state.func_177230_c().getHarvestTool(state);
        Set emulatedToolClass = emulatedTool.func_77973_b().getToolClasses(emulatedTool);
        for (String tool : emulatedToolClass) {
            if (!state.func_177230_c().isToolEffective(tool, state) && !Objects.equals(state.func_177230_c().getHarvestTool(state), tool)) continue;
            return true;
        }
        if (emulatedTool.func_77973_b().func_150897_b(state)) {
            return true;
        }
        if (effectiveTool == null) {
            Item.ToolMaterial material = emulatedTool.func_77973_b() instanceof ItemTool ? ((ItemTool)emulatedTool.func_77973_b()).func_150913_i() : Item.ToolMaterial.IRON;
            if (emulatedTool.func_150997_a(state) >= material.func_77998_b()) {
                return true;
            }
        }
        return false;
    }

    public static boolean blockCheckAndHarvest(EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == null || block == Blocks.field_150350_a) {
            return false;
        }
        if ((block instanceof IShearable || block instanceof BlockFlower || block instanceof BlockBush || block instanceof BlockLeaves) && block.canHarvestBlock((IBlockAccess)world, pos, player) || block == Blocks.field_150433_aE || block == Blocks.field_150431_aC) {
            block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), new ItemStack(Items.field_151037_a));
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }
}

