/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.lang.reflect.Method;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.common.ModCompatibility;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TreetapModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_TREETAP = "Treetap";
    public static final String TREETAP_ENERGY_CONSUMPTION = "Energy Consumption";
    public static ItemStack resin;
    public static Block rubber_wood;
    public static ItemStack emulatedTool;
    private Method attemptExtract;
    private boolean isIC2Classic;
    public static ItemStack treetap;

    public TreetapModule(List<IModularItem> validItems) {
        super(validItems);
        if (ModCompatibility.isIndustrialCraftClassicLoaded()) {
            emulatedTool = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ic2", "itemTreetapElectric")), 1);
            treetap = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ic2", "itemTreetap")), 1);
            resin = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ic2", "misc_resource")), 1, 4);
            rubber_wood = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("ic2", "blockRubWood"));
            try {
                this.attemptExtract = treetap.func_77973_b().getClass().getDeclaredMethod("attemptExtract", ItemStack.class, EntityPlayer.class, World.class, BlockPos.class, EnumFacing.class, List.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isIC2Classic = true;
        } else {
            emulatedTool = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ic2", "electric_treetap")), 1);
            treetap = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ic2", "treetap")), 1);
            resin = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ic2", "misc_resource")), 1, 4);
            rubber_wood = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("ic2", "rubber_wood"));
            try {
                this.attemptExtract = treetap.func_77973_b().getClass().getDeclaredMethod("attemptExtract", EntityPlayer.class, World.class, BlockPos.class, EnumFacing.class, IBlockState.class, List.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isIC2Classic = false;
        }
        this.addBaseProperty(TREETAP_ENERGY_CONSUMPTION, 100.0);
        this.addInstallCost(emulatedTool);
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        try {
            if (this.isIC2Classic) {
                if (block == rubber_wood && ModuleManager.computeModularProperty(itemStack, TREETAP_ENERGY_CONSUMPTION) < ElectricItemUtils.getPlayerEnergy(player) && this.attemptExtract.invoke((Object)"attemptExtract", null, player, world, pos, facing, null).equals(true)) {
                    ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(itemStack, TREETAP_ENERGY_CONSUMPTION));
                    return EnumActionResult.SUCCESS;
                }
            } else if (block == rubber_wood && ModuleManager.computeModularProperty(itemStack, TREETAP_ENERGY_CONSUMPTION) < ElectricItemUtils.getPlayerEnergy(player) && this.attemptExtract.invoke((Object)"attemptExtract", player, world, pos, facing, state, null).equals(true)) {
                ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(itemStack, TREETAP_ENERGY_CONSUMPTION));
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        catch (Exception exception) {
            return EnumActionResult.FAIL;
        }
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_TREETAP;
    }

    @Override
    public String getUnlocalizedName() {
        return "treetap";
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(emulatedTool).func_177554_e();
    }
}

