/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.weapon;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.entity.EntitySpinningBlade;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BladeLauncherModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_BLADE_LAUNCHER = "Blade Launcher";
    public static final String BLADE_ENERGY = "Spinning Blade Energy Consumption";
    public static final String BLADE_DAMAGE = "Spinning Blade Damage";

    public BladeLauncherModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(BLADE_ENERGY, 500.0, "J");
        this.addBaseProperty(BLADE_DAMAGE, 6.0, "pt");
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.mvcapacitor, 1));
    }

    @Override
    public String getCategory() {
        return "Weapon";
    }

    @Override
    public String getDataName() {
        return MODULE_BLADE_LAUNCHER;
    }

    @Override
    public String getUnlocalizedName() {
        return "bladeLauncher";
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND && ElectricItemUtils.getPlayerEnergy(playerIn) > ModuleManager.computeModularProperty(itemStackIn, BLADE_ENERGY)) {
            playerIn.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)this);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!worldIn.field_72995_K) {
            double energyConsumption = ModuleManager.computeModularProperty(itemStack, BLADE_ENERGY);
            if (ElectricItemUtils.getPlayerEnergy((EntityPlayer)entityLiving) > energyConsumption) {
                ElectricItemUtils.drainPlayerEnergy((EntityPlayer)entityLiving, energyConsumption);
                EntitySpinningBlade blade = new EntitySpinningBlade(worldIn, entityLiving);
                worldIn.func_72838_d((Entity)blade);
            }
        }
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.bladeLauncher;
    }
}

