/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.utils;

import java.util.LinkedList;
import java.util.List;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.electricity.ElectricAdapter;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.item.ItemPowerFist;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class MuseCommonStrings {
    public static final String ARMOR_VALUE_PHYSICAL = "Armor (Physical)";
    public static final String ARMOR_VALUE_ENERGY = "Armor (Energy)";
    public static final String ARMOR_ENERGY_CONSUMPTION = "Energy Per Damage";
    public static final String WEIGHT = "Weight";
    public static final String MODULE_ANTIGRAVITY = "Antigravity Drive";
    public static final String CATEGORY_ARMOR = "Armor";
    public static final String CATEGORY_ENERGY = "Energy";
    public static final String CATEGORY_TOOL = "Tool";
    public static final String CATEGORY_WEAPON = "Weapon";
    public static final String CATEGORY_MOVEMENT = "Movement";
    public static final String CATEGORY_COSMETIC = "Cosmetic";
    public static final String CATEGORY_VISION = "Vision";
    public static final String CATEGORY_ENVIRONMENTAL = "Environment";
    public static final String CATEGORY_SPECIAL = "Special";

    public static void addInformation(ItemStack stack, EntityPlayer player, List currentTipList, boolean advancedToolTips) {
        ElectricAdapter adapter;
        if (stack.func_77973_b() instanceof ItemPowerFist) {
            String mode = MuseItemUtils.getStringOrNull(stack, "Mode");
            if (mode != null) {
                currentTipList.add(I18n.func_135052_a((String)"tooltip.mode", (Object[])new Object[0]) + " " + MuseStringUtils.wrapFormatTags(mode, MuseStringUtils.FormatCodes.Red));
            } else {
                currentTipList.add(I18n.func_135052_a((String)"tooltip.changeModes", (Object[])new Object[0]));
            }
        }
        if ((adapter = ElectricAdapter.wrap(stack)) != null) {
            String energyinfo = I18n.func_135052_a((String)"tooltip.energy", (Object[])new Object[0]) + " " + MuseStringUtils.formatNumberShort(adapter.getCurrentMPSEnergy()) + '/' + MuseStringUtils.formatNumberShort(adapter.getMaxMPSEnergy());
            currentTipList.add(MuseStringUtils.wrapMultipleFormatTags(energyinfo, new Object[]{Character.valueOf(MuseStringUtils.FormatCodes.Italic.character), MuseStringUtils.FormatCodes.Grey}));
        }
        if (Config.doAdditionalInfo()) {
            List<String> installed = MuseCommonStrings.getItemInstalledModules(player, stack);
            if (installed.size() == 0) {
                String message = I18n.func_135052_a((String)"tooltip.noModules", (Object[])new Object[0]);
                currentTipList.addAll(MuseStringUtils.wrapStringToLength(message, 30));
            } else {
                currentTipList.add(I18n.func_135052_a((String)"tooltip.installedModules", (Object[])new Object[0]));
                currentTipList.addAll(installed);
            }
        } else {
            currentTipList.add(Config.additionalInfoInstructions());
        }
    }

    public static double getOrSetModuleProperty(NBTTagCompound moduleTag, String propertyName, double defaultValue) {
        if (!moduleTag.func_74764_b(propertyName)) {
            moduleTag.func_74780_a(propertyName, defaultValue);
        }
        return moduleTag.func_74769_h(propertyName);
    }

    public static double getTotalWeight(ItemStack stack) {
        return ModuleManager.computeModularProperty(stack, WEIGHT);
    }

    public static List<String> getItemInstalledModules(EntityPlayer player, ItemStack stack) {
        NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
        LinkedList<String> modules = new LinkedList<String>();
        for (IPowerModule module : ModuleManager.getValidModulesForItem(stack)) {
            if (!ModuleManager.tagHasModule(itemTag, module.getDataName())) continue;
            modules.add(module.getDataName());
        }
        return modules;
    }
}

