/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.blocks.growables;

import com.pam.harvestcraft.blocks.growables.PamCropGrowable;
import com.pam.harvestcraft.config.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLLog;

public class BlockPamCrop
extends BlockCrops
implements IGrowable,
IPlantable,
PamCropGrowable {
    private static final int MATURE_AGE = 3;
    private static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private final String registerName;
    public final String name;
    private String BASE_STAGE_ID = null;
    private Item seed;
    private Item food;

    public void setSeed(Item seed) {
        if (ConfigHandler.cropsdropSeeds) {
            this.seed = seed;
        }
        this.seed = this.food;
    }

    public void setFood(Item food) {
        this.food = food;
    }

    public BlockPamCrop(String registerName, String name) {
        this.registerName = registerName;
        this.name = name;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(0)));
    }

    public String getStageId(int stage) {
        if (this.BASE_STAGE_ID == null) {
            this.BASE_STAGE_ID = this.registerName.replaceFirst("pam", "").replace("Crop", "") + "_stage";
        }
        return this.BASE_STAGE_ID + stage;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)AGE) * 2];
    }

    private boolean isSuitableSoilBlock(Block soilBlock) {
        return soilBlock == Blocks.field_150458_ak;
    }

    public PropertyInteger func_185524_e() {
        return AGE;
    }

    @Override
    public int getMatureAge() {
        return 3;
    }

    @Override
    public boolean isMature(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.func_185524_e()) >= 3;
    }

    public Item func_149866_i() {
        if (this.seed == null) {
            FMLLog.bigWarning((String)"No seed have been set up for %s.", (Object[])new Object[]{this.func_149739_a()});
            return new Item();
        }
        return this.seed;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.func_149866_i());
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMature(state);
    }

    public Item func_149865_P() {
        if (this.food == null) {
            FMLLog.bigWarning((String)"No food has been set up for %s.", (Object[])new Object[]{this.func_149739_a()});
            return new Item();
        }
        return this.food;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(meta));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        float f;
        int currentGrowthLevel;
        this.func_176475_e(worldIn, pos, state);
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && (currentGrowthLevel = this.func_176201_c(state)) < this.getMatureAge() && rand.nextInt((int)(50.0f / (f = BlockPamCrop.func_180672_a((Block)this, (World)worldIn, (BlockPos)pos))) + 1) == 0) {
            worldIn.func_180501_a(pos, this.func_176203_a(currentGrowthLevel + 1), 2);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (!this.isMature(state)) {
            return this.func_149866_i();
        }
        return this.func_149865_P();
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.func_185524_e());
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        Block soilBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return this.isSuitableSoilBlock(soilBlock);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List<ItemStack> items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : items) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockPamCrop.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    private int getRandomInt(World world) {
        return MathHelper.func_76136_a((Random)world.field_73012_v, (int)1, (int)3);
    }

    public void func_176487_g(World worldIn, BlockPos pos, IBlockState state) {
        int newGrowth = this.func_176201_c(state) + this.getRandomInt(worldIn);
        if (newGrowth > 3) {
            newGrowth = 3;
        }
        worldIn.func_180501_a(pos, this.func_176203_a(newGrowth), 2);
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.func_176487_g(worldIn, pos, state);
    }

    public int hashCode() {
        return this.registerName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof BlockPamCrop && this.registerName.equals(((BlockPamCrop)obj).registerName);
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int i;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int age = this.func_176201_c(state);
        int count = this.quantityDropped(state, fortune, rand);
        for (i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.func_180651_a(state)));
        }
        if (age >= this.getMatureAge()) {
            for (i = 0; i < 3 + fortune; ++i) {
                if (rand.nextInt(2 * this.getMatureAge()) > age) continue;
                ret.add(new ItemStack(this.func_149866_i(), 1, 0));
            }
        }
        return ret;
    }

    protected boolean func_185514_i(IBlockState state) {
        return this.isSuitableSoilBlock(state.func_177230_c());
    }

    public int func_185526_g() {
        return this.getMatureAge();
    }

    protected int func_185527_x(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState func_185528_e(int age) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age));
    }

    public boolean func_185525_y(IBlockState state) {
        return this.func_185527_x(state) >= this.func_185526_g();
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return this.func_185527_x(state) < this.func_185526_g();
    }
}

