/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.davincisvessels.client;

import io.github.elytra.davincisvessels.client.control.ShipKeyHandler;
import io.github.elytra.davincisvessels.client.handler.ClientHookContainer;
import io.github.elytra.davincisvessels.client.render.RenderParachute;
import io.github.elytra.davincisvessels.client.render.RenderSeat;
import io.github.elytra.davincisvessels.client.render.TileEntityGaugeRenderer;
import io.github.elytra.davincisvessels.client.render.TileEntityHelmRenderer;
import io.github.elytra.davincisvessels.common.CommonProxy;
import io.github.elytra.davincisvessels.common.DavincisVesselsConfig;
import io.github.elytra.davincisvessels.common.entity.EntityParachute;
import io.github.elytra.davincisvessels.common.entity.EntitySeat;
import io.github.elytra.davincisvessels.common.entity.EntityShip;
import io.github.elytra.davincisvessels.common.object.DavincisVesselsObjects;
import io.github.elytra.davincisvessels.common.tileentity.TileGauge;
import io.github.elytra.davincisvessels.common.tileentity.TileHelm;
import io.github.elytra.movingworld.client.render.RenderMovingWorld;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.LoaderState;

public class ClientProxy
extends CommonProxy {
    public ShipKeyHandler shipKeyHandler;
    public DavincisVesselsConfig syncedConfig;

    @Override
    public ClientHookContainer getHookContainer() {
        return new ClientHookContainer();
    }

    @Override
    public void registerKeyHandlers(DavincisVesselsConfig cfg) {
        this.shipKeyHandler = new ShipKeyHandler(cfg);
        MinecraftForge.EVENT_BUS.register((Object)this.shipKeyHandler);
    }

    @Override
    public void registerRenderers(LoaderState.ModState state) {
        if (state == LoaderState.ModState.PREINITIALIZED) {
            this.registerEntityRenderers();
            this.registerRendererVariants();
        }
        if (state == LoaderState.ModState.INITIALIZED) {
            this.registerTileEntitySpeacialRenderers();
            this.registerItemRenderers();
        }
        if (state == LoaderState.ModState.POSTINITIALIZED) {
            // empty if block
        }
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityShip.class, manager -> new RenderMovingWorld(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityParachute.class, manager -> new RenderParachute(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntitySeat.class, manager -> new RenderSeat(manager));
    }

    public void registerTileEntitySpeacialRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileGauge.class, (TileEntitySpecialRenderer)new TileEntityGaugeRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileHelm.class, (TileEntitySpecialRenderer)new TileEntityHelmRenderer());
    }

    public void registerRendererVariants() {
        Item itemToRegister = null;
        ArrayList<ResourceLocation> variants = null;
        itemToRegister = Item.func_150898_a((Block)DavincisVesselsObjects.blockBalloon);
        variants = new ArrayList<ResourceLocation>();
        for (EnumDyeColor color : EnumDyeColor.values()) {
            variants.add(new ResourceLocation("davincisvessels:balloon_" + color.func_176610_l()));
        }
        ResourceLocation[] variantsArray = new ResourceLocation[variants.size()];
        int index = 0;
        Iterator iterator = variants.iterator();
        while (iterator.hasNext()) {
            ResourceLocation str;
            variantsArray[index] = str = (ResourceLocation)iterator.next();
            ++index;
        }
        ModelBakery.registerItemVariants((Item)itemToRegister, (ResourceLocation[])variantsArray);
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)DavincisVesselsObjects.blockGauge), (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("davincisvessels:gauge"), new ResourceLocation("davincisvessels:gauge_ext")});
    }

    public void registerItemRenderers() {
        int i;
        Item itemToRegister = null;
        ModelResourceLocation modelResourceLocation = null;
        ItemModelMesher modelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        for (i = 0; i < DavincisVesselsObjects.registeredBlocks.size(); ++i) {
            modelResourceLocation = new ModelResourceLocation("davincisvessels:" + DavincisVesselsObjects.registeredBlocks.keySet().toArray()[i], "inventory");
            itemToRegister = Item.func_150898_a((Block)((Block)DavincisVesselsObjects.registeredBlocks.values().toArray()[i]));
            modelMesher.func_178086_a(itemToRegister, 0, modelResourceLocation);
        }
        for (i = 0; i < DavincisVesselsObjects.registeredItems.size(); ++i) {
            modelResourceLocation = new ModelResourceLocation("davincisvessels:" + DavincisVesselsObjects.registeredItems.keySet().toArray()[i], "inventory");
            itemToRegister = (Item)DavincisVesselsObjects.registeredItems.values().toArray()[i];
            modelMesher.func_178086_a(itemToRegister, 0, modelResourceLocation);
        }
        itemToRegister = Item.func_150898_a((Block)DavincisVesselsObjects.blockGauge);
        modelResourceLocation = new ModelResourceLocation("davincisvessels:gauge_ext", "inventory");
        modelMesher.func_178086_a(itemToRegister, 1, modelResourceLocation);
        itemToRegister = Item.func_150898_a((Block)DavincisVesselsObjects.blockBalloon);
        modelResourceLocation = null;
        for (EnumDyeColor color : EnumDyeColor.values()) {
            modelResourceLocation = new ModelResourceLocation("davincisvessels:balloon_" + color.func_176610_l(), "inventory");
            modelMesher.func_178086_a(itemToRegister, color.func_176765_a(), modelResourceLocation);
        }
    }
}

