/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.davincisvessels.client.render;

import io.github.elytra.davincisvessels.DavincisVesselsMod;
import io.github.elytra.davincisvessels.common.entity.EntityShip;
import io.github.elytra.davincisvessels.common.object.block.BlockHelm;
import io.github.elytra.davincisvessels.common.tileentity.TileHelm;
import java.io.IOException;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;

public class TileEntityHelmRenderer
extends TileEntitySpecialRenderer<TileHelm> {
    public void renderTileEntityAt(TileHelm te, double x, double y, double z, float partialTicks, int destroyStage) {
        try {
            this.renderHelm(te, x, y, z, partialTicks);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                e.printStackTrace();
            }
            DavincisVesselsMod.LOG.error("Error when rendering helm, ", (Throwable)e);
        }
    }

    private void renderHelm(TileHelm helm, double x, double y, double z, float partialTicks) throws Exception {
        float translateZ;
        float translateY;
        float translateX;
        boolean onZAxis;
        EntityShip ship = null;
        IBlockState blockState = this.func_178459_a().func_180495_p(helm.func_174877_v());
        EnumFacing blockStateFacing = EnumFacing.UP;
        if (blockState.func_177230_c() instanceof BlockHelm) {
            blockStateFacing = (EnumFacing)blockState.func_177229_b((IProperty)BlockHelm.field_176387_N);
        }
        if (helm.getParentMovingWorld() != null && helm.getParentMovingWorld() instanceof EntityShip) {
            ship = (EntityShip)helm.getParentMovingWorld();
        }
        float shipPitch = 0.0f;
        if (ship != null) {
            shipPitch = ship.field_70127_C + (ship.field_70125_A - ship.field_70127_C) * partialTicks;
        }
        if (blockStateFacing == EnumFacing.NORTH || blockStateFacing == EnumFacing.WEST) {
            shipPitch *= -1.0f;
        }
        boolean bl = onZAxis = blockStateFacing.func_176740_k() == EnumFacing.Axis.Z;
        if (onZAxis) {
            translateX = 0.5f;
            translateY = 0.625f;
            translateZ = 0.0f;
        } else {
            translateX = 0.0f;
            translateY = 0.625f;
            translateZ = -0.5f;
        }
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179091_B();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)(z + 1.0));
        GlStateManager.func_179109_b((float)translateX, (float)translateY, (float)translateZ);
        GlStateManager.func_179114_b((float)(shipPitch * 10.0f), (float)(onZAxis ? 0.0f : 1.0f), (float)0.0f, (float)(onZAxis ? 1.0f : 0.0f));
        GlStateManager.func_179109_b((float)(-translateX), (float)(-translateY), (float)(-translateZ));
        IBlockState wheelState = blockState.func_177226_a((IProperty)BlockHelm.IS_WHEEL, (Comparable)Boolean.valueOf(true));
        IBakedModel stateModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(wheelState);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178266_a(stateModel, wheelState, 1.0f, false);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }
}

