/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.davincisvessels.common.tileentity;

import io.github.elytra.davincisvessels.common.tileentity.BlockLocation;
import io.github.elytra.davincisvessels.common.util.NBTTagUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;

public class AnchorInstance
implements INBTSerializable<NBTTagCompound> {
    private UUID identifier = UUID.randomUUID();
    private InstanceType type = InstanceType.FORLAND;
    private boolean changed = false;
    private Map<UUID, BlockLocation> relatedAnchors = new HashMap<UUID, BlockLocation>();

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
        this.changed = true;
    }

    public InstanceType getType() {
        return this.type;
    }

    public void setType(InstanceType type) {
        this.type = type;
        this.changed = true;
    }

    public Map<UUID, BlockLocation> getRelatedAnchors() {
        return this.relatedAnchors;
    }

    public void setRelatedAnchors(Map<UUID, BlockLocation> relatedAnchors) {
        this.relatedAnchors = relatedAnchors;
        this.changed = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnchorInstance that = (AnchorInstance)o;
        return Objects.equals(this.getIdentifier(), that.getIdentifier()) && this.getType() == that.getType() && Objects.equals(this.getRelatedAnchors(), that.getRelatedAnchors());
    }

    public void addRelation(UUID identifier, BlockLocation location) {
        this.relatedAnchors.put(identifier, location);
        this.changed = true;
    }

    public String toString() {
        return "AnchorInstance{identifier=" + this.identifier + ", type=" + (Object)((Object)this.type) + ", relatedAnchors=" + this.relatedAnchors + '}';
    }

    public void clearRelations() {
        this.relatedAnchors.clear();
        this.changed = true;
    }

    public void removeRelation(UUID identifier) {
        this.relatedAnchors.remove(identifier);
        this.changed = true;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("INSTANCE", true);
        tag.func_74757_a("type", this.type == InstanceType.FORSHIP);
        tag.func_186854_a("identifier", this.identifier);
        if (!this.relatedAnchors.isEmpty()) {
            NBTTagList relatedAnchorsTagList = tag.func_150295_c("relatedAnchorsTagList", 10);
            for (Map.Entry<UUID, BlockLocation> e : this.relatedAnchors.entrySet()) {
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_186854_a("identifier", e.getKey());
                entry.func_74768_a("dimID", e.getValue().dimID);
                NBTTagUtils.writeVec3iToNBT(entry, "related", (Vec3i)e.getValue().pos);
                relatedAnchorsTagList.func_74742_a((NBTBase)entry);
            }
            tag.func_74782_a("relatedAnchorsTagList", (NBTBase)relatedAnchorsTagList);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (!tag.func_74764_b("INSTANCE")) {
            throw new IllegalArgumentException("NBT provided for deserialization is not valid for an anchor point! " + tag.toString());
        }
        this.type = tag.func_74767_n("type") ? InstanceType.FORSHIP : InstanceType.FORLAND;
        this.identifier = tag.func_186857_a("identifier");
        if (tag.func_74764_b("relatedAnchorsTagList")) {
            NBTTagList relatedAnchorsTagList = tag.func_150295_c("relatedAnchorsTagList", 10);
            int size = relatedAnchorsTagList.func_74745_c();
            for (int entry = 0; entry < size; ++entry) {
                NBTTagCompound entryCompound = relatedAnchorsTagList.func_150305_b(entry);
                int entryDimID = entryCompound.func_74762_e("dimID");
                BlockPos entryPos = new BlockPos(NBTTagUtils.readVec3iFromNBT(entryCompound, "related"));
                UUID entryIdentifier = entryCompound.func_186857_a("identifier");
                this.relatedAnchors.put(entryIdentifier, new BlockLocation(entryPos, entryDimID));
            }
        }
    }

    public static enum InstanceType {
        FORSHIP,
        FORLAND;


        public String toString() {
            if (FMLLaunchHandler.side().isClient()) {
                return this == FORSHIP ? I18n.func_135052_a((String)"gui.davincis.anchor.mode.ship", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.davincis.anchor.mode.world", (Object[])new Object[0]);
            }
            return super.toString();
        }

        public InstanceType opposite() {
            switch (this) {
                case FORLAND: {
                    return FORSHIP;
                }
                case FORSHIP: {
                    return FORLAND;
                }
            }
            return this;
        }
    }
}

