/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.davincisvessels.common.tileentity;

import io.github.elytra.davincisvessels.common.api.tileentity.ITileEngineModifier;
import io.github.elytra.davincisvessels.common.entity.ShipCapabilities;
import io.github.elytra.movingworld.common.chunk.mobilechunk.MobileChunk;
import io.github.elytra.movingworld.common.entity.EntityMovingWorld;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileEngine
extends TileEntity
implements IInventory,
ITileEngineModifier {
    public float enginePower;
    public int engineFuelConsumption;
    ItemStack[] itemStacks = new ItemStack[this.func_70302_i_()];
    private int burnTime = 0;
    private boolean running = false;
    private BlockPos chunkPos;

    public TileEngine() {
    }

    public TileEngine(float power, int fuelconsumption) {
        this();
        this.enginePower = power;
        this.engineFuelConsumption = fuelconsumption;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.burnTime = tag.func_74762_e("burn");
        this.engineFuelConsumption = tag.func_74765_d("fuelCons");
        this.enginePower = tag.func_74760_g("power");
        NBTTagList list = tag.func_150295_c("inv", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound comp = list.func_150305_b(i);
            byte j = comp.func_74771_c("i");
            this.itemStacks[j] = ItemStack.func_77949_a((NBTTagCompound)comp);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("burn", this.burnTime);
        tag.func_74777_a("fuelCons", (short)this.engineFuelConsumption);
        tag.func_74776_a("power", this.enginePower);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.itemStacks[i] == null) continue;
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74774_a("i", (byte)i);
            this.itemStacks[i].func_77955_b(comp);
            list.func_74742_a((NBTBase)comp);
        }
        tag.func_74782_a("inv", (NBTBase)list);
        return tag;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public boolean consumeFuel(int f) {
        if (this.burnTime >= f) {
            this.burnTime -= f;
            return true;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack is = this.func_70298_a(i, 1);
            if (is == null || is.field_77994_a <= 0) continue;
            this.burnTime += TileEntityFurnace.func_145952_a((ItemStack)is);
            return this.consumeFuel(f);
        }
        return false;
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int i) {
        return i >= 0 && i < 4 ? this.itemStacks[i] : null;
    }

    public ItemStack func_70298_a(int i, int n) {
        if (this.itemStacks[i] != null) {
            if (this.itemStacks[i].field_77994_a <= n) {
                ItemStack itemstack = this.itemStacks[i];
                this.itemStacks[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.itemStacks[i].func_77979_a(n);
            if (this.itemStacks[i].field_77994_a <= 0) {
                this.itemStacks[i] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack content = this.itemStacks[i].func_77946_l();
        this.itemStacks[i] = null;
        return content;
    }

    public void func_70299_a(int i, ItemStack is) {
        if (i >= 0 && i < 4) {
            this.itemStacks[i] = is;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return i >= 0 && i < 4 && TileEntityFurnace.func_145954_b((ItemStack)is);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.itemStacks = new ItemStack[this.func_70302_i_()];
    }

    public String func_70005_c_() {
        return "container.davincis.shipEngine";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString("Engine Inventory");
    }

    @Override
    public float getPowerIncrement(ShipCapabilities shipCapabilities) {
        return this.isRunning() ? this.enginePower : 0.0f;
    }

    public void setParentMovingWorld(EntityMovingWorld movingWorld, BlockPos chunkPos) {
        this.chunkPos = this.field_174879_c;
    }

    public EntityMovingWorld getParentMovingWorld() {
        return null;
    }

    public void setParentMovingWorld(EntityMovingWorld entityMovingWorld) {
    }

    public BlockPos getChunkPos() {
        return this.chunkPos;
    }

    public void setChunkPos(BlockPos chunkPos) {
    }

    public void tick(MobileChunk mobileChunk) {
        this.running = this.consumeFuel(this.engineFuelConsumption);
    }
}

