/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2;

import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.dave.cm2.command.CommandCM2;
import org.dave.cm2.gui.GuiHandler;
import org.dave.cm2.init.Blockss;
import org.dave.cm2.init.Fluidss;
import org.dave.cm2.init.Itemss;
import org.dave.cm2.init.Potionss;
import org.dave.cm2.init.Recipes;
import org.dave.cm2.integration.CapabilityNullHandlerRegistry;
import org.dave.cm2.miniaturization.MiniaturizationEvents;
import org.dave.cm2.miniaturization.MultiblockRecipes;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.misc.Villager;
import org.dave.cm2.network.PackageHandler;
import org.dave.cm2.proxy.CommonProxy;
import org.dave.cm2.world.ChunkLoadingMachines;
import org.dave.cm2.world.WorldGenMachines;
import org.dave.cm2.world.WorldSavedDataMachines;
import org.dave.cm2.world.tools.DimensionTools;

@Mod(modid="cm2", version="1.0", acceptedMinecraftVersions="[1.10.2]")
public class CompactMachines2 {
    public static final String MODID = "cm2";
    public static final String VERSION = "1.0";
    @Mod.Instance(value="cm2")
    public static CompactMachines2 instance;
    @SidedProxy(clientSide="org.dave.cm2.proxy.ClientProxy", serverSide="org.dave.cm2.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static File cfgDirectory;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)new ConfigurationHandler());
        MinecraftForge.EVENT_BUS.register(WorldSavedDataMachines.class);
        MinecraftForge.EVENT_BUS.register(MiniaturizationEvents.class);
        cfgDirectory = new File(event.getModConfigurationDirectory(), "cm2-schemas");
        cfgDirectory.mkdirs();
        DimensionTools.registerDimension();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenMachines(), (int)-1024);
        GuiHandler.init();
        Fluidss.init();
        Blockss.init();
        Itemss.init();
        Potionss.init();
        MultiblockRecipes.init();
        Recipes.init();
        Villager.init();
        CapabilityNullHandlerRegistry.registerNullHandlers(event.getAsmData());
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PackageHandler.init();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"org.dave.cm2.misc.WailaProvider.register");
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new ChunkLoadingMachines());
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCM2());
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }
}

