/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.cm2.block.BlockBase;
import org.dave.cm2.block.IMetaBlockName;
import org.dave.cm2.init.Blockss;
import org.dave.cm2.item.ItemPersonalShrinkingDevice;
import org.dave.cm2.item.psd.PSDFluidStorage;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.misc.CreativeTabCM2;
import org.dave.cm2.reference.EnumMachineSize;
import org.dave.cm2.tile.TileEntityMachine;
import org.dave.cm2.tile.TileEntityTunnel;
import org.dave.cm2.world.ChunkLoadingMachines;
import org.dave.cm2.world.WorldSavedDataMachines;
import org.dave.cm2.world.tools.DimensionTools;
import org.dave.cm2.world.tools.TeleportationTools;

public class BlockMachine
extends BlockBase
implements IMetaBlockName,
ITileEntityProvider {
    public static final PropertyEnum<EnumMachineSize> SIZE = PropertyEnum.func_177709_a((String)"size", EnumMachineSize.class);

    public BlockMachine(Material material) {
        super(material);
        this.func_149711_c(8.0f);
        this.func_149752_b(20.0f);
        this.func_149647_a(CreativeTabCM2.CM2_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SIZE, (Comparable)((Object)EnumMachineSize.TINY)));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, world, pos, blockIn);
        if (world.field_72995_K) {
            return;
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityMachine)) {
            return;
        }
        TileEntityMachine te = (TileEntityMachine)world.func_175625_s(pos);
        if (te.lastNeighborUpdateTick == world.func_82737_E()) {
            return;
        }
        te.lastNeighborUpdateTick = world.func_82737_E();
        for (EnumFacing side : EnumFacing.values()) {
            WorldServer machineWorld;
            BlockPos neighborPos = te.getTunnelForSide(side);
            if (neighborPos == null || !((machineWorld = DimensionTools.getServerMachineWorld()).func_175625_s(neighborPos) instanceof TileEntityTunnel)) continue;
            machineWorld.func_175685_c(neighborPos, Blockss.tunnel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (EnumMachineSize size : EnumMachineSize.values()) {
            list.add(new ItemStack((Block)this, 1, size.getMeta()));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIZE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachineSize)((Object)state.func_177229_b(SIZE))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SIZE, (Comparable)((Object)EnumMachineSize.getFromMeta(meta)));
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return ((EnumMachineSize)((Object)this.func_176203_a(stack.func_77952_i()).func_177229_b(SIZE))).func_176610_l();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMachine();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            super.func_180663_b(world, pos, state);
            return;
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityMachine)) {
            return;
        }
        TileEntityMachine te = (TileEntityMachine)world.func_175625_s(pos);
        WorldSavedDataMachines.INSTANCE.removeMachinePosition(te.coords);
        BlockMachine.spawnItemWithNBT(world, pos, (EnumMachineSize)((Object)state.func_177229_b(SIZE)), te);
        ChunkLoadingMachines.unforceChunk(te.coords);
        world.func_175713_t(pos);
        super.func_180663_b(world, pos, state);
    }

    public static void spawnItemWithNBT(World world, BlockPos pos, EnumMachineSize size, TileEntityMachine te) {
        if (world.field_72995_K) {
            return;
        }
        ItemStack stack = new ItemStack(Blockss.machine, 1, size.getMeta());
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("coords", te.coords);
        if (te.hasOwner()) {
            compound.func_186854_a("owner", te.getOwner());
        }
        stack.func_77982_d(compound);
        if (te.getCustomName().length() > 0) {
            stack.func_151001_c(te.getCustomName());
        }
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), stack);
        entityItem.lifespan = 1200;
        entityItem.func_174867_a(10);
        float motionMultiplier = 0.02f;
        entityItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
        entityItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * motionMultiplier + 0.1f;
        entityItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
        world.func_72838_d((Entity)entityItem);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!(world.func_175625_s(pos) instanceof TileEntityMachine)) {
            return;
        }
        TileEntityMachine tileEntityMachine = (TileEntityMachine)world.func_175625_s(pos);
        if (tileEntityMachine.coords != -1) {
            return;
        }
        if (stack.func_77942_o()) {
            int coords;
            if (stack.func_77978_p().func_74764_b("coords") && (coords = stack.func_77978_p().func_74762_e("coords")) != -1) {
                tileEntityMachine.coords = coords;
            }
            if (stack.func_82837_s()) {
                tileEntityMachine.setCustomName(stack.func_82833_r());
            }
            if (stack.func_77978_p().func_74764_b("owner")) {
                tileEntityMachine.setOwner(stack.func_77978_p().func_186857_a("owner"));
            }
        }
        if (!tileEntityMachine.hasOwner() && placer instanceof EntityPlayer) {
            tileEntityMachine.setOwner((EntityPlayer)placer);
        }
        tileEntityMachine.func_70296_d();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityMachine)) {
            return false;
        }
        TileEntityMachine machine = (TileEntityMachine)world.func_175625_s(pos);
        ItemStack playerStack = player.func_184614_ca();
        if (playerStack != null) {
            Item playerItem = playerStack.func_77973_b();
            if (playerItem instanceof ItemPersonalShrinkingDevice) {
                boolean freeToGo;
                PSDFluidStorage tank = (PSDFluidStorage)((Object)playerStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
                boolean bl = freeToGo = ConfigurationHandler.MachineSettings.fluidCostForEntering == 0 || player.field_71075_bZ.field_75098_d;
                if (!freeToGo && tank != null && tank.getFluidAmount() >= 250) {
                    tank.drainInternal(250, true);
                    freeToGo = true;
                }
                if (freeToGo) {
                    TeleportationTools.teleportPlayerToMachine((EntityPlayerMP)player, machine);
                    WorldSavedDataMachines.INSTANCE.addMachinePosition(machine.coords, pos, world.field_73011_w.getDimension());
                } else {
                    TextComponentTranslation tc = new TextComponentTranslation("item.cm2.psd.not_enough_fluid", new Object[0]);
                    tc.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
                    player.func_146105_b((ITextComponent)tc);
                }
            } else if (playerStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
                if (!FluidUtil.interactWithFluidHandler((ItemStack)playerStack, (IFluidHandler)((IFluidHandler)machine.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)), (EntityPlayer)player)) {
                    return false;
                }
                machine.func_70296_d();
            }
        }
        return true;
    }
}

