/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import org.dave.cm2.init.Fluidss;
import org.dave.cm2.miniaturization.MiniaturizationPotion;
import org.dave.cm2.miniaturization.MultiblockRecipes;
import org.dave.cm2.misc.ConfigurationHandler;

public class BlockMiniaturizationFluid
extends BlockFluidClassic {
    public BlockMiniaturizationFluid() {
        super(Fluidss.miniaturizationFluid, Material.field_151586_h);
        this.func_149663_c("miniaturization_fluid_block");
        this.setQuantaPerBlock(4);
        this.setTickRate(5);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        if (!(entity instanceof EntityLivingBase)) {
            Item item;
            if (entity instanceof EntityItem && MultiblockRecipes.isCatalystItem(item = ((EntityItem)entity).func_92059_d().func_77973_b())) {
                if (!world.field_72995_K) {
                    if (entity.field_70128_L) {
                        return;
                    }
                    entity.func_70106_y();
                    ItemStack result = MultiblockRecipes.tryCrafting(world, pos, item);
                    if (result != null) {
                        Vec3d entityPosition = entity.func_174791_d();
                        EntityItem entityItem = new EntityItem(world, entityPosition.field_72450_a, entityPosition.field_72448_b, entityPosition.field_72449_c, result);
                        entityItem.lifespan = 2400;
                        entityItem.func_174867_a(10);
                        entityItem.field_70159_w = 0.0;
                        entityItem.field_70181_x = 0.55f;
                        entityItem.field_70179_y = 0.0;
                        world.func_72838_d((Entity)entityItem);
                    }
                } else {
                    Vec3d entityPosition = entity.func_174791_d();
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, entityPosition.field_72450_a, entityPosition.field_72448_b + (double)0.05f, entityPosition.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, entityPosition.field_72450_a + (double)0.05f, entityPosition.field_72448_b, entityPosition.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, entityPosition.field_72450_a, entityPosition.field_72448_b - (double)0.05f, entityPosition.field_72449_c + (double)0.05f, 0.0, 0.0, 0.0, new int[0]);
                    world.func_184134_a(entityPosition.field_72450_a, entityPosition.field_72448_b, entityPosition.field_72449_c, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f, 1.0f, false);
                }
            }
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        int duration = ConfigurationHandler.PotionSettings.onBlockContactDuration;
        int amplifier = ConfigurationHandler.PotionSettings.onBlockContactAmplifier;
        MiniaturizationPotion.applyPotion((EntityLivingBase)entity, duration, amplifier);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        BlockPos[] adjacent = new BlockPos[]{pos.func_177982_a(1, 0, 0), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(0, 0, -1), pos.func_177982_a(1, 0, 1), pos.func_177982_a(1, 0, -1), pos.func_177982_a(-1, 0, -1), pos.func_177982_a(-1, 0, 1)};
        if (this.isSourceBlock((IBlockAccess)world, pos)) {
            for (BlockPos adjPos : adjacent) {
                this.flowIntoBlock(world, adjPos, 1);
            }
        } else {
            boolean hasAdjacentSourceBlock = false;
            for (BlockPos adjPos : adjacent) {
                if (!this.isSourceBlock((IBlockAccess)world, adjPos)) continue;
                hasAdjacentSourceBlock = true;
                break;
            }
            if (!hasAdjacentSourceBlock && world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                int quantaRemaining = this.quantaPerBlock - (Integer)state.func_177229_b((IProperty)LEVEL);
                if (quantaRemaining > 0) {
                    world.func_175656_a(pos, this.func_176194_O().func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)LEVEL) + 1)));
                    world.func_175685_c(pos.func_177977_b(), (Block)this);
                } else if (quantaRemaining <= 0) {
                    world.func_175698_g(pos);
                }
            }
        }
        if (this.canDisplace((IBlockAccess)world, pos.func_177977_b())) {
            this.flowIntoBlock(world, pos.func_177977_b(), 1);
            return;
        }
    }
}

