/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.block;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.dave.cm2.block.BlockProtected;
import org.dave.cm2.init.Blockss;
import org.dave.cm2.init.Itemss;
import org.dave.cm2.tile.TileEntityMachine;
import org.dave.cm2.tile.TileEntityTunnel;
import org.dave.cm2.utility.DimensionBlockPos;
import org.dave.cm2.world.WorldSavedDataMachines;
import org.dave.cm2.world.tools.DimensionTools;
import org.dave.cm2.world.tools.StructureTools;

public class BlockTunnel
extends BlockProtected
implements ITileEntityProvider {
    public static final PropertyDirection MACHINE_SIDE = PropertyDirection.func_177714_a((String)"machineside");

    public BlockTunnel(Material material) {
        super(material);
        this.func_149713_g(1);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MACHINE_SIDE, (Comparable)EnumFacing.DOWN));
    }

    @Override
    public boolean isBlockProtected(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        EnumFacing connectedSide = (EnumFacing)state.func_177229_b((IProperty)MACHINE_SIDE);
        EnumFacing nextDirection = StructureTools.getNextDirection(connectedSide);
        int coords = StructureTools.getCoordsForPos(pos);
        HashMap<EnumFacing, BlockPos> sideMapping = WorldSavedDataMachines.INSTANCE.tunnels.get(coords);
        while (sideMapping != null) {
            if (nextDirection == null) {
                if (world.func_175625_s(pos) != null) {
                    world.func_175713_t(pos);
                }
                IBlockState blockState = Blockss.wall.func_176223_P();
                world.func_175656_a(pos, blockState);
                BlockPos inset = pos.func_177972_a(side);
                EntityItem entityItem = new EntityItem(world, (double)inset.func_177958_n(), (double)inset.func_177956_o(), (double)inset.func_177952_p(), new ItemStack(Itemss.tunnelTool, 1));
                entityItem.lifespan = 1200;
                entityItem.func_174867_a(10);
                float f3 = 0.05f;
                entityItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                entityItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                entityItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                world.func_72838_d((Entity)entityItem);
                WorldSavedDataMachines.INSTANCE.removeTunnel(pos);
                break;
            }
            if (sideMapping.get(nextDirection) == null) {
                if (world.func_175625_s(pos) != null) {
                    world.func_175713_t(pos);
                }
                world.func_175656_a(pos, state.func_177226_a((IProperty)MACHINE_SIDE, (Comparable)nextDirection));
                WorldSavedDataMachines.INSTANCE.removeTunnel(pos, connectedSide);
                WorldSavedDataMachines.INSTANCE.addTunnel(pos, nextDirection);
                break;
            }
            nextDirection = StructureTools.getNextDirection(nextDirection);
        }
        this.notifyOverworldNeighbor(pos);
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, world, pos, blockIn);
        if (world.field_72995_K) {
            return;
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityTunnel)) {
            return;
        }
        this.notifyOverworldNeighbor(pos);
    }

    public void notifyOverworldNeighbor(BlockPos pos) {
        DimensionBlockPos dimpos = WorldSavedDataMachines.INSTANCE.machinePositions.get(StructureTools.getCoordsForPos(pos));
        if (dimpos == null) {
            return;
        }
        WorldServer realWorld = DimensionTools.getWorldServerForDimension(dimpos.getDimension());
        if (realWorld == null || !(realWorld.func_175625_s(dimpos.getBlockPos()) instanceof TileEntityMachine)) {
            return;
        }
        realWorld.func_175685_c(dimpos.getBlockPos(), Blockss.machine);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MACHINE_SIDE, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)MACHINE_SIDE)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MACHINE_SIDE});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTunnel();
    }
}

