/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.block;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.dave.cm2.block.BlockProtected;
import org.dave.cm2.block.BlockTunnel;
import org.dave.cm2.init.Blockss;
import org.dave.cm2.item.ItemTunnelTool;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.misc.CreativeTabCM2;
import org.dave.cm2.world.WorldSavedDataMachines;
import org.dave.cm2.world.tools.StructureTools;

public class BlockWall
extends BlockProtected {
    public BlockWall(Material material) {
        super(material);
        this.func_149713_g(1);
        this.func_149715_a(1.0f);
        this.func_149647_a(CreativeTabCM2.CM2_TAB);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem == null || !(heldItem.func_77973_b() instanceof ItemTunnelTool) || heldItem.field_77994_a <= 0) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        if (world.field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
            return false;
        }
        EnumFacing tunnelSide = EnumFacing.DOWN;
        int coords = StructureTools.getCoordsForPos(pos);
        HashMap<EnumFacing, BlockPos> sideMapping = WorldSavedDataMachines.INSTANCE.tunnels.get(coords);
        while (sideMapping != null && tunnelSide != null && sideMapping.get(tunnelSide) != null) {
            tunnelSide = StructureTools.getNextDirection(tunnelSide);
        }
        if (tunnelSide != null) {
            IBlockState blockState = Blockss.tunnel.func_176223_P().func_177226_a((IProperty)BlockTunnel.MACHINE_SIDE, (Comparable)tunnelSide);
            world.func_175656_a(pos, blockState);
            --heldItem.field_77994_a;
            WorldSavedDataMachines.INSTANCE.addTunnel(pos, tunnelSide);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "All tunnels already used up"));
        }
        return true;
    }
}

