/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.command;

import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.dave.cm2.CompactMachines2;
import org.dave.cm2.command.CommandBaseExt;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.schema.BlockInformation;
import org.dave.cm2.schema.Schema;
import org.dave.cm2.tile.TileEntityMachine;
import org.dave.cm2.utility.SerializationHelper;
import org.dave.cm2.world.WorldSavedDataMachines;
import org.dave.cm2.world.tools.DimensionTools;
import org.dave.cm2.world.tools.StructureTools;

public class CommandSchemaLoad
extends CommandBaseExt {
    public String func_71517_b() {
        return "load";
    }

    @Override
    public boolean isAllowed(EntityPlayer player, boolean creative, boolean isOp) {
        return creative || isOp;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw this.getUsageException(sender);
        }
        String sane = args[0].replaceAll("[^a-zA-Z0-9\\._]+", "_") + ".json";
        File schemaFile = new File(CompactMachines2.cfgDirectory, sane);
        Schema schema = null;
        try {
            schema = (Schema)SerializationHelper.GSON.fromJson(new JsonReader((Reader)new FileReader(schemaFile)), Schema.class);
        }
        catch (FileNotFoundException e) {
            throw this.getException(sender, "invalid_file");
        }
        if (schema == null) {
            throw this.getException(sender, "not_deserializable");
        }
        List<BlockInformation> blockList = schema.blocks;
        if (sender.func_174793_f() != null && sender.func_174793_f() instanceof EntityLivingBase) {
            if (sender.func_130014_f_().field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
                throw this.getException(sender, "not_in_machine_dimension");
            }
            int coords = StructureTools.getCoordsForPos(sender.func_174793_f().func_180425_c());
            TileEntity te = WorldSavedDataMachines.INSTANCE.getMachinePosition(coords).getTileEntity();
            if (te != null && te instanceof TileEntityMachine) {
                WorldServer machineWorld = DimensionTools.getServerMachineWorld();
                TileEntityMachine machine = (TileEntityMachine)te;
                int size = machine.getSize().getDimension();
                int startX = machine.coords * 1024 + size - 1;
                int startY = 40 + size - 1;
                int startZ = 0 + size - 1;
                for (BlockInformation bi : blockList) {
                    BlockPos absolutePos = new BlockPos(startX - bi.position.func_177958_n(), startY - bi.position.func_177956_o(), startZ - bi.position.func_177952_p());
                    IBlockState state = bi.block.func_176203_a(bi.meta);
                    machineWorld.func_175656_a(absolutePos, state);
                    if (bi.nbt == null) continue;
                    TileEntity restoredTe = machineWorld.func_175625_s(absolutePos);
                    if (restoredTe == null) {
                        restoredTe = bi.block.createTileEntity((World)machineWorld, state);
                    }
                    if (bi.writePositionData) {
                        bi.nbt.func_74768_a("x", absolutePos.func_177958_n());
                        bi.nbt.func_74768_a("y", absolutePos.func_177956_o());
                        bi.nbt.func_74768_a("z", absolutePos.func_177952_p());
                    }
                    restoredTe.func_145839_a(bi.nbt);
                    restoredTe.func_70296_d();
                }
            }
        }
    }
}

