/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.command;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.dave.cm2.CompactMachines2;
import org.dave.cm2.command.CommandBaseExt;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.schema.BlockInformation;
import org.dave.cm2.schema.Schema;
import org.dave.cm2.utility.SerializationHelper;
import org.dave.cm2.world.tools.StructureTools;

public class CommandSchemaSave
extends CommandBaseExt {
    public String func_71517_b() {
        return "save";
    }

    @Override
    public boolean isAllowed(EntityPlayer player, boolean creative, boolean isOp) {
        return creative || isOp;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw this.getUsageException(sender);
        }
        String sane = args[0].replaceAll("[^a-zA-Z0-9\\._]+", "_") + ".json";
        if (sender.func_174793_f() != null && sender.func_174793_f() instanceof EntityLivingBase) {
            if (sender.func_130014_f_().field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
                throw this.getException(sender, "not_in_machine_dimension");
            }
            int coords = StructureTools.getCoordsForPos(sender.func_174793_f().func_180425_c());
            List<BlockInformation> blockList = StructureTools.getSchema(coords);
            if (blockList != null) {
                Schema schema = new Schema(args[0], blockList);
                try {
                    File schemaFile = new File(CompactMachines2.cfgDirectory, sane);
                    BufferedWriter writer = new BufferedWriter(new FileWriter(schemaFile));
                    String json = SerializationHelper.GSON.toJson((Object)schema);
                    writer.write(json);
                    writer.close();
                    sender.func_145747_a((ITextComponent)new TextComponentString("Wrote schema to file: " + sane));
                }
                catch (IOException e) {
                    throw this.getException(sender, "invalid_file");
                }
            } else {
                throw this.getException(sender, "not_serializable");
            }
        }
    }
}

