/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.item;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.dave.cm2.CompactMachines2;
import org.dave.cm2.block.BlockMiniaturizationFluid;
import org.dave.cm2.init.Blockss;
import org.dave.cm2.init.Fluidss;
import org.dave.cm2.item.ItemBase;
import org.dave.cm2.item.psd.PSDCapabilityProvider;
import org.dave.cm2.item.psd.PSDFluidStorage;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.misc.CreativeTabCM2;
import org.dave.cm2.reference.GuiIds;
import org.dave.cm2.utility.TextFormattingHelper;
import org.dave.cm2.world.WorldSavedDataMachines;
import org.dave.cm2.world.tools.StructureTools;
import org.dave.cm2.world.tools.TeleportationTools;

public class ItemPersonalShrinkingDevice
extends ItemBase {
    public ItemPersonalShrinkingDevice() {
        this.func_77637_a(CreativeTabCM2.CM2_TAB);
        this.func_77625_d(1);
        this.func_77656_e(4000);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        PSDFluidStorage tank = (PSDFluidStorage)((Object)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
        return 1.0 - (double)tank.getFluidAmount() / (double)tank.getCapacity();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new PSDCapabilityProvider(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        PSDFluidStorage tank = (PSDFluidStorage)((Object)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
        String chargeToolTip = I18n.func_135052_a((String)"tooltip.cm2.psd.charge", (Object[])new Object[]{tank.getFluidAmount() * 100 / tank.getCapacity()});
        tooltip.add(TextFormattingHelper.colorizeKeyValue(chargeToolTip));
        if (GuiScreen.func_146272_n()) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.cm2.psd.hint", (Object[])new Object[0]));
        }
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean isDamaged(ItemStack stack) {
        PSDFluidStorage tank = (PSDFluidStorage)((Object)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
        return tank.getFluidAmount() != 0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult raytraceresult;
        if (hand == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        PSDFluidStorage tank = (PSDFluidStorage)((Object)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
        if (tank.getFluidAmount() <= 3500 && (raytraceresult = this.func_77621_a(world, player, true)) != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            boolean allowed;
            BlockPos tracepos = raytraceresult.func_178782_a();
            IBlockState state = world.func_180495_p(tracepos);
            boolean bl = allowed = world.func_175660_a(player, tracepos) && player.func_175151_a(tracepos.func_177972_a(raytraceresult.field_178784_b), raytraceresult.field_178784_b, itemStack);
            if (allowed && state.func_177230_c() == Blockss.miniaturizationFluidBlock && (Integer)state.func_177229_b((IProperty)BlockMiniaturizationFluid.LEVEL) == 0) {
                world.func_180501_a(tracepos, Blocks.field_150350_a.func_176223_P(), 11);
                player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                tank.fill(new FluidStack(Fluidss.miniaturizationFluid, 1000), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
            }
        }
        if (world.field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
            player.openGui((Object)CompactMachines2.instance, GuiIds.PSD_WELCOME.ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        if (!world.field_72995_K && world.field_73011_w.getDimension() == ConfigurationHandler.Settings.dimensionId && player instanceof EntityPlayerMP) {
            EntityPlayerMP serverPlayer = (EntityPlayerMP)player;
            if (player.func_70093_af()) {
                int coords = StructureTools.getCoordsForPos(player.func_180425_c());
                Vec3d pos = player.func_174791_d();
                WorldSavedDataMachines.INSTANCE.addSpawnPoint(coords, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                TextComponentTranslation tc = new TextComponentTranslation("item.cm2.psd.spawnpoint_set", new Object[0]);
                tc.func_150256_b().func_150238_a(TextFormatting.GREEN);
                player.func_146105_b((ITextComponent)tc);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
            }
            TeleportationTools.teleportPlayerOutOfMachine(serverPlayer);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }
}

