/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.jei;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class MultiblockRecipeCategory
extends BlankRecipeCategory
implements ITooltipCallback<ItemStack> {
    public static final String UID = "cm2.MultiblockMiniaturization";
    private final String localizedName = I18n.func_135052_a((String)"cm2.jei.category.multiblock_miniaturization", (Object[])new Object[0]);
    private final IDrawableStatic background;
    private final IDrawableStatic slotDrawable;

    public MultiblockRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(150, 110);
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.slotDrawable.draw(minecraft, 0, 0);
        this.slotDrawable.draw(minecraft, 0, 19);
        this.slotDrawable.draw(minecraft, 0, 38);
        this.slotDrawable.draw(minecraft, 0, 57);
        this.slotDrawable.draw(minecraft, 0, 76);
        this.slotDrawable.draw(minecraft, 0, 95);
        this.slotDrawable.draw(minecraft, 135, 76);
        this.slotDrawable.draw(minecraft, 135, 95);
        this.slotDrawable.draw(minecraft, 135, 0);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().init(1, true, 0, 19);
        recipeLayout.getItemStacks().init(2, true, 0, 38);
        recipeLayout.getItemStacks().init(3, true, 0, 57);
        recipeLayout.getItemStacks().init(4, true, 0, 76);
        recipeLayout.getItemStacks().init(5, true, 0, 95);
        recipeLayout.getItemStacks().init(6, true, 135, 76);
        recipeLayout.getItemStacks().init(7, true, 135, 95);
        recipeLayout.getItemStacks().init(8, false, 135, 0);
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)this);
        recipeLayout.getItemStacks().set(ingredients);
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        String last = tooltip.get(tooltip.size() - 1);
        tooltip.remove(tooltip.size() - 1);
        if (slotIndex >= 0 && slotIndex <= 5) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.cm2.jei.shape", (Object[])new Object[0]));
        }
        if (slotIndex == 6) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.cm2.jei.fluid", (Object[])new Object[0]));
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.cm2.jei.fluid.warning", (Object[])new Object[0]));
        }
        if (slotIndex == 7) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.cm2.jei.crafting_trigger", (Object[])new Object[0]));
        }
        tooltip.add(last);
    }
}

