/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.UniversalBucket;
import org.dave.cm2.init.Fluidss;
import org.dave.cm2.miniaturization.MiniaturizationEvents;
import org.dave.cm2.miniaturization.MultiblockRecipe;

public class MultiblockRecipeWrapper
extends BlankRecipeWrapper {
    public final MultiblockRecipe recipe;
    private final List<ItemStack> input = new ArrayList<ItemStack>();
    private int requiredBuckets;

    public MultiblockRecipeWrapper(MultiblockRecipe recipe) {
        this.recipe = recipe;
        BlockPos minPos = recipe.getMinPos();
        BlockPos maxPos = recipe.getMaxPos();
        int diffX = maxPos.func_177958_n() - minPos.func_177958_n() + 1;
        int diffZ = maxPos.func_177952_p() - minPos.func_177952_p() + 1;
        int reqX = (int)Math.ceil((float)diffX / 2.0f);
        int reqZ = (int)Math.ceil((float)diffZ / 2.0f);
        this.requiredBuckets = reqX * reqZ;
        int added = 0;
        for (ItemStack stack : this.recipe.getRequiredItemStacks()) {
            this.input.add(stack);
            ++added;
        }
        for (int emptySlot = 0; emptySlot < 6 - added; ++emptySlot) {
            this.input.add(null);
        }
        this.input.add(UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)Fluidss.miniaturizationFluid));
        this.input.add(this.recipe.getCatalystStack());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.input);
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.getTargetStack());
    }

    public void renderLayer(BlockRendererDispatcher blockrendererdispatcher, VertexBuffer buffer, BlockRenderLayer renderLayer, List<BlockPos> toRender) {
        for (BlockPos pos : toRender) {
            IBlockState state = this.recipe.getStateAtBlockPos(pos);
            if (!state.func_177230_c().canRenderInLayer(state, renderLayer)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
            try {
                blockrendererdispatcher.func_175018_a(state, pos, this.recipe.getBlockAccess(), buffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ForgeHooksClient.setRenderLayer(null);
        }
    }

    public void drawInfo(Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        List<BlockPos> toRender;
        BlockPos minPos = this.recipe.getMinPos();
        BlockPos maxPos = this.recipe.getMaxPos();
        int reqX = (int)Math.ceil((float)(maxPos.func_177958_n() - minPos.func_177958_n() + 2) / 2.0f);
        int reqZ = (int)Math.ceil((float)(maxPos.func_177952_p() - minPos.func_177952_p() + 2) / 2.0f);
        this.requiredBuckets = reqX * reqZ;
        if (this.requiredBuckets > 1) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)216.5f);
            if (this.requiredBuckets < 10) {
                mc.field_71466_p.func_175063_a("~" + this.requiredBuckets, 141.0f, 86.0f, 0xFFFFFF);
            } else {
                mc.field_71466_p.func_175063_a("~" + this.requiredBuckets, 135.0f, 86.0f, 0xFFFFFF);
            }
            GlStateManager.func_179121_F();
        }
        if ((toRender = this.recipe.getShapeAsBlockPosList()).isEmpty()) {
            return;
        }
        float angle = (float)MiniaturizationEvents.renderTicks * 45.0f / 128.0f;
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179106_n();
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(recipeWidth / 2), (float)(recipeHeight / 2), (float)100.0f);
        GlStateManager.func_179114_b((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)-16.0f, (float)16.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        BlockPos mn = this.recipe.getMinPos();
        BlockPos mx = this.recipe.getMaxPos();
        int diffX = mx.func_177958_n() - mn.func_177958_n();
        int diffY = mx.func_177956_o() - mn.func_177956_o();
        int diffZ = mx.func_177952_p() - mn.func_177952_p();
        int maxDiff = Math.max(Math.max(diffZ, diffX), diffY) + 1;
        float scale = 1.0f / ((float)maxDiff / 4.0f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)((float)(diffX + 1) / -2.0f), (float)((float)(diffY + 1) / -2.0f), (float)((float)(diffZ + 1) / -2.0f));
        boolean renderWireframe = false;
        if (GuiScreen.func_146272_n()) {
            renderWireframe = true;
            GlStateManager.func_187409_d((int)1032, (int)6913);
        }
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        GlStateManager.func_179118_c();
        this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.SOLID, toRender);
        GlStateManager.func_179141_d();
        this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT_MIPPED, toRender);
        this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT, toRender);
        GlStateManager.func_179103_j((int)7425);
        this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.TRANSLUCENT, toRender);
        tessellator.func_78381_a();
        if (renderWireframe) {
            GlStateManager.func_187409_d((int)1032, (int)6914);
        }
        GlStateManager.func_179121_F();
    }
}

