/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.miniaturization;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.cm2.init.Itemss;
import org.dave.cm2.init.Potionss;
import org.dave.cm2.item.psd.PSDFluidStorage;
import org.dave.cm2.miniaturization.MiniaturizationPotion;
import org.dave.cm2.misc.Villager;

public class MiniaturizationEvents {
    public static int renderTicks = 0;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onLivingEntityRenderPre(RenderLivingEvent.Pre event) {
        GlStateManager.func_179094_E();
        IAttributeInstance scaleAttribute = event.getEntity().func_110140_aT().func_111151_a(Potionss.scaleAttribute);
        if (scaleAttribute == null || scaleAttribute.func_111126_e() == 1.0) {
            return;
        }
        double scale = scaleAttribute.func_111126_e();
        GlStateManager.func_179137_b((double)(-event.getX() * scale + event.getX()), (double)(-event.getY() * scale + event.getY()), (double)(-event.getZ() * scale + event.getZ()));
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onLivingEntityRenderPost(RenderLivingEvent.Post event) {
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public static void onPlayerTick_CheckOffhand(TickEvent.PlayerTickEvent event) {
        FluidStack drainedStack;
        if (event.side != Side.SERVER) {
            return;
        }
        EntityPlayer player = event.player;
        ItemStack offHandItemStack = player.func_184592_cb();
        if (offHandItemStack == null || offHandItemStack.func_77973_b() != Itemss.psd) {
            return;
        }
        PSDFluidStorage tank = (PSDFluidStorage)((Object)offHandItemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
        if (tank == null) {
            return;
        }
        if (player.func_70660_b(Potionss.miniaturizationPotion) == null && (drainedStack = tank.drainInternal(40, true)) != null && drainedStack.amount > 0) {
            MiniaturizationPotion.applyPotion((EntityLivingBase)player, drainedStack.amount, 3);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        IAttributeInstance scaleAttribute = event.player.func_110140_aT().func_111151_a(Potionss.scaleAttribute);
        if (scaleAttribute == null) {
            return;
        }
        double scale = scaleAttribute.func_111126_e();
        MiniaturizationPotion.setEntitySize((EntityLivingBase)event.player, (float)scale);
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++renderTicks;
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        IAttributeInstance scaleAttribute = entity.func_110140_aT().func_111151_a(Potionss.scaleAttribute);
        if (scaleAttribute == null || scaleAttribute.func_111126_e() == 1.0) {
            return;
        }
        double scale = scaleAttribute.func_111126_e();
        if (entity.field_70181_x >= 0.0) {
            entity.field_70181_x *= MathHelper.func_151237_a((double)(scale * 2.0), (double)0.5, (double)1.0);
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(EntityEvent.EntityConstructing event) {
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)event.getEntity();
        entity.func_110140_aT().func_111150_b(Potionss.scaleAttribute);
    }

    @SubscribeEvent
    public static void onLivingEnterChunk(EntityEvent.EnteringChunk event) {
        if (!(event.getEntity() instanceof EntityVillager)) {
            return;
        }
        EntityVillager villager = (EntityVillager)event.getEntity();
        if (villager.getProfessionForge().equals(Villager.shrinker)) {
            MiniaturizationPotion.applyPotion((EntityLivingBase)villager, Integer.MAX_VALUE, 2);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        IAttributeInstance scaleAttribute = entity.func_110140_aT().func_111151_a(Potionss.scaleAttribute);
        if (scaleAttribute == null || scaleAttribute.func_111126_e() == 1.0) {
            return;
        }
        double baseChance = 0.1f;
        double scale = scaleAttribute.func_111126_e();
        baseChance *= 1.0 / scale;
        if (event.getLootingLevel() > 0) {
            baseChance *= (double)event.getLootingLevel() / 2.0 + 1.0;
        }
        if (Math.random() > baseChance) {
            return;
        }
        ItemStack miniFluidDropDrop = new ItemStack(Itemss.miniFluidDrop);
        EntityItem entityItem = new EntityItem(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, miniFluidDropDrop);
        event.getDrops().add(entityItem);
    }
}

