/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.miniaturization;

import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import org.dave.cm2.init.Potionss;

public class MiniaturizationPotion
extends Potion {
    public static final AttributeModifier[] SCALE_MODIFIER = new AttributeModifier[]{new AttributeModifier("Scale 75%", -0.25, 0), new AttributeModifier("Scale 50%", -0.5, 0), new AttributeModifier("Scale 25%", -0.75, 0), new AttributeModifier("Scale 12.5%", -0.875, 0)};

    public MiniaturizationPotion(boolean isBadEffectIn, int liquidColorIn) {
        super(isBadEffectIn, liquidColorIn);
        this.func_76390_b("effect.shrink");
        this.func_76399_b(3, 2);
        this.func_111184_a(SharedMonsterAttributes.field_111263_d, "838296b1-ad82-438b-ba64-89633b5472f0", -0.15, 2);
    }

    public boolean func_76403_b() {
        return true;
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return false;
    }

    public void func_111185_a(EntityLivingBase entityLivingBaseIn, AbstractAttributeMap attributeMap, int amplifier) {
        super.func_111185_a(entityLivingBaseIn, attributeMap, amplifier);
        if (amplifier < 0 || amplifier > 3) {
            return;
        }
        IAttributeInstance scaleAttribute = attributeMap.func_111151_a(Potionss.scaleAttribute);
        if (scaleAttribute != null) {
            Collection collection = scaleAttribute.func_111122_c();
            if (collection != null) {
                Lists.newArrayList((Iterable)collection).forEach(arg_0 -> ((IAttributeInstance)scaleAttribute).func_111124_b(arg_0));
            }
            scaleAttribute.func_111121_a(SCALE_MODIFIER[amplifier]);
        }
    }

    public void func_111187_a(EntityLivingBase entityLivingBaseIn, AbstractAttributeMap attributeMap, int amplifier) {
        super.func_111187_a(entityLivingBaseIn, attributeMap, amplifier);
        MiniaturizationPotion.setEntitySize(entityLivingBaseIn, 1.0f);
        if (amplifier < 0 || amplifier > 3) {
            return;
        }
        IAttributeInstance scaleAttribute = attributeMap.func_111151_a(Potionss.scaleAttribute);
        if (scaleAttribute != null) {
            scaleAttribute.func_111124_b(SCALE_MODIFIER[amplifier]);
        }
    }

    private static BaseSize getBaseValues(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return new BaseSize(0.6f, 1.8f);
        }
        try {
            Constructor<?> c = entity.getClass().getDeclaredConstructor(World.class);
            c.setAccessible(true);
            EntityLivingBase copy = (EntityLivingBase)c.newInstance(entity.func_130014_f_());
            return new BaseSize(copy.field_70130_N, copy.field_70131_O);
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new BaseSize(0.6f, 1.8f);
    }

    public static void setEntitySize(EntityLivingBase entity, float scale) {
        BaseSize baseSize = MiniaturizationPotion.getBaseValues(entity);
        float baseWidth = baseSize.width;
        float baseHeight = baseSize.height;
        float newWidth = baseWidth * scale;
        float newHeight = baseHeight * scale;
        AxisAlignedBB originalBB = entity.func_174813_aQ();
        entity.field_70130_N = newWidth;
        entity.field_70131_O = newHeight;
        AxisAlignedBB newBB = new AxisAlignedBB(entity.field_70165_t - (double)(newWidth / 2.0f), originalBB.field_72338_b, entity.field_70161_v - (double)(newWidth / 2.0f), entity.field_70165_t + (double)(newWidth / 2.0f), originalBB.field_72338_b + (double)newHeight, entity.field_70161_v + (double)(newWidth / 2.0f));
        entity.func_174826_a(newBB);
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).eyeHeight = ((EntityPlayer)entity).getDefaultEyeHeight() * scale;
        }
    }

    public static void applyPotion(EntityLivingBase entity, int duration, int amplifier) {
        if (duration <= 0) {
            return;
        }
        PotionEffect active = entity.func_70660_b(Potionss.miniaturizationPotion);
        PotionEffect effect = new PotionEffect(Potionss.miniaturizationPotion, duration, amplifier, false, false);
        if (active != null) {
            active.func_76452_a(effect);
        } else {
            entity.func_70690_d(effect);
        }
    }

    private static class BaseSize {
        float width;
        float height;

        public BaseSize(float width, float height) {
            this.width = width;
            this.height = height;
        }
    }
}

