/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.miniaturization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.dave.cm2.miniaturization.MultiblockRecipe;
import org.dave.cm2.utility.Logz;

public class MultiblockRecipeSerializer
implements JsonSerializer<MultiblockRecipe>,
JsonDeserializer<MultiblockRecipe> {
    public MultiblockRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String itemId;
        int targetMeta;
        if (!json.isJsonObject()) {
            Logz.info("Invalid recipe! Not a json object!", new Object[0]);
            return null;
        }
        JsonObject jsonRoot = json.getAsJsonObject();
        if (!jsonRoot.has("input-types") || !jsonRoot.has("shape")) {
            Logz.info("Invalid recipe! Missing section shape and/or input-types!", new Object[0]);
            return null;
        }
        ItemStack targetStack = null;
        int targetCount = jsonRoot.has("target-count") ? jsonRoot.get("target-count").getAsInt() : 1;
        int n = targetMeta = jsonRoot.has("target-meta") ? jsonRoot.get("target-meta").getAsInt() : 0;
        if (jsonRoot.has("target-block")) {
            String blockId = jsonRoot.get("target-block").getAsString();
            Block targetBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockId));
            if (targetBlock == null) {
                throw new RuntimeException("Invalid recipe! Unknown target block: \"" + blockId + "\"");
            }
            targetStack = new ItemStack(targetBlock, targetCount, targetMeta);
        } else if (jsonRoot.has("target-item")) {
            String itemId2 = jsonRoot.get("target-item").getAsString();
            Item targetItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemId2));
            if (targetItem == null) {
                throw new RuntimeException("Invalid recipe! Unknown target item: \"" + itemId2 + "\"");
            }
            targetStack = new ItemStack(targetItem, targetCount, targetMeta);
        }
        if (targetStack == null) {
            return null;
        }
        Item catalystItem = Items.field_151137_ax;
        if (jsonRoot.has("catalyst") && (catalystItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemId = jsonRoot.get("catalyst").getAsString()))) == null) {
            throw new RuntimeException("Invalid recipe! Unknown target item: \"" + itemId + "\"");
        }
        int catalystMeta = 0;
        if (jsonRoot.has("catalyst-meta")) {
            catalystMeta = jsonRoot.get("catalyst-meta").getAsInt();
        }
        MultiblockRecipe result = new MultiblockRecipe(targetStack, catalystItem, catalystMeta);
        JsonObject jsonReferenceMap = jsonRoot.get("input-types").getAsJsonObject();
        for (Map.Entry entry : jsonReferenceMap.entrySet()) {
            JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
            if (!data.has("id")) {
                Logz.error("Missing id for source block", new Object[0]);
                return null;
            }
            String blockId = data.get("id").getAsString();
            Iterator sourceBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockId));
            if (sourceBlock == null) {
                throw new RuntimeException("Invalid recipe! Unknown source block: \"" + blockId + "\"");
            }
            int meta = data.has("meta") ? data.get("meta").getAsInt() : 0;
            IBlockState state = sourceBlock.func_176203_a(meta);
            if (state == null) {
                state = sourceBlock.func_176223_P();
            }
            result.addBlockReference((String)entry.getKey(), state);
        }
        JsonArray jsonYPosArray = jsonRoot.get("shape").getAsJsonArray();
        int height = jsonYPosArray.size();
        int width = 0;
        int depth = 0;
        for (JsonElement jsonYElement : jsonYPosArray) {
            JsonArray jsonZPosArray = jsonYElement.getAsJsonArray();
            depth = Math.max(depth, jsonZPosArray.size());
            for (JsonElement jsonZElement : jsonZPosArray) {
                JsonArray jsonXPosArray = jsonZElement.getAsJsonArray();
                width = Math.max(width, jsonXPosArray.size());
            }
        }
        String[][][] positionMap = new String[height][depth][width];
        int y = 0;
        for (JsonElement jsonYElement : jsonYPosArray) {
            int z = 0;
            for (JsonElement jsonZElement : jsonYElement.getAsJsonArray()) {
                int x = 0;
                for (JsonElement jsonXElement : jsonZElement.getAsJsonArray()) {
                    String ref;
                    positionMap[height - 1 - y][z][x] = ref = jsonXElement.getAsString();
                    ++x;
                }
                ++z;
            }
            ++y;
        }
        result.setPositionMap(positionMap);
        return result;
    }

    public JsonElement serialize(MultiblockRecipe src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject root = new JsonObject();
        return root;
    }
}

