/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.miniaturization;

import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.dave.cm2.CompactMachines2;
import org.dave.cm2.block.BlockMiniaturizationFluid;
import org.dave.cm2.init.Blockss;
import org.dave.cm2.miniaturization.MultiblockRecipe;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.utility.Logz;
import org.dave.cm2.utility.SerializationHelper;
import org.dave.cm2.world.tools.RecursiveSearch;

public class MultiblockRecipes {
    private static List<MultiblockRecipe> recipes = new ArrayList<MultiblockRecipe>();

    public static List<MultiblockRecipe> getRecipes() {
        return recipes;
    }

    public static void init() {
        MultiblockRecipes.loadRecipes();
    }

    public static ItemStack tryCrafting(World world, BlockPos contactPos, Item item) {
        ArrayList<BlockPos> fluidBlocks = new RecursiveSearch(world, contactPos, Blockss.miniaturizationFluidBlock, -1, true).getResult();
        BlockPos insidePos = null;
        int lowestY = 255;
        for (BlockPos pos : fluidBlocks) {
            IBlockState state = world.func_180495_p(pos);
            if (pos.func_177956_o() < lowestY) {
                lowestY = pos.func_177956_o();
            }
            IBlockState stateBelow = world.func_180495_p(pos.func_177977_b());
            if (state.func_177230_c().func_176201_c(state) != 0 || stateBelow.func_177230_c() == Blockss.miniaturizationFluidBlock || insidePos != null && insidePos.func_177956_o() >= pos.func_177956_o()) continue;
            insidePos = pos;
        }
        if (insidePos == null) {
            return null;
        }
        Logz.info("starting search at %s", insidePos.func_177977_b());
        ArrayList<BlockPos> insideBlocks = new RecursiveSearch(world, insidePos.func_177977_b(), Blockss.miniaturizationFluidBlock, lowestY, false).getResult();
        for (MultiblockRecipe recipe : recipes) {
            if (!recipe.tryCrafting(world, insideBlocks, item)) continue;
            for (BlockPos fluidPos : fluidBlocks) {
                IBlockState state = world.func_180495_p(fluidPos);
                if (state.func_177230_c() != Blockss.miniaturizationFluidBlock || (Integer)state.func_177229_b((IProperty)BlockMiniaturizationFluid.LEVEL) != 0) continue;
                world.func_175656_a(fluidPos, state.func_177226_a((IProperty)BlockMiniaturizationFluid.LEVEL, (Comparable)Integer.valueOf(1)));
            }
            insideBlocks.forEach(arg_0 -> ((World)world).func_175698_g(arg_0));
            return recipe.getTargetStack();
        }
        return null;
    }

    private static void loadRecipes() {
        String resourcePath = "assets/cm2/config/recipes";
        ArrayList<String> loadedLocalRecipes = new ArrayList<String>();
        File localRecipeDir = new File(ConfigurationHandler.cmDirectory, "recipes");
        if (localRecipeDir.exists()) {
            for (File file : localRecipeDir.listFiles()) {
                MultiblockRecipe recipe = null;
                try {
                    recipe = (MultiblockRecipe)SerializationHelper.GSON.fromJson(new JsonReader((Reader)new FileReader(file)), MultiblockRecipe.class);
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
                if (recipe == null) {
                    Logz.error("Could not deserialize recipe from file: \"" + file.getPath() + "\"", new Object[0]);
                    continue;
                }
                Logz.info("Loaded recipe \"%s\" from config folder", file.getName());
                recipes.add(recipe);
                loadedLocalRecipes.add(file.getName());
            }
        }
        boolean isJar = false;
        Path myPath = null;
        try {
            URI uri = CompactMachines2.class.getResource("/" + resourcePath).toURI();
            if (uri.getScheme().equals("jar")) {
                FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                myPath = fs.getPath("/" + resourcePath, new String[0]);
                isJar = true;
            } else {
                myPath = Paths.get(uri);
            }
        }
        catch (URISyntaxException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        if (myPath == null) {
            throw new RuntimeException("Could not list recipes from path: \"" + resourcePath + "\"");
        }
        try {
            Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                String pathWithForeslash = path.toString().replace('\\', '/');
                if (pathWithForeslash.endsWith(resourcePath) || loadedLocalRecipes.contains(path.getFileName().toString())) continue;
                MultiblockRecipe recipe = null;
                if (isJar) {
                    InputStream in = CompactMachines2.instance.getClass().getClassLoader().getResourceAsStream(resourcePath + "/" + path.getFileName());
                    recipe = (MultiblockRecipe)SerializationHelper.GSON.fromJson((Reader)new InputStreamReader(in), MultiblockRecipe.class);
                    if (recipe == null) {
                        throw new RuntimeException("Could not deserialize recipe from jar: \"" + path.toString() + "\"");
                    }
                    Logz.info("Loaded recipe \"%s\" from jar", path.getFileName());
                } else {
                    try {
                        recipe = (MultiblockRecipe)SerializationHelper.GSON.fromJson(new JsonReader((Reader)new FileReader(path.toFile())), MultiblockRecipe.class);
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                    if (recipe == null) {
                        throw new RuntimeException("Could not deserialize recipe from file: \"" + path.toString() + "\"");
                    }
                    Logz.info("Loaded recipe \"%s\" from disk (dev environment?)", path.getFileName());
                }
                if (recipe == null) continue;
                recipes.add(recipe);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isCatalystItem(Item item) {
        for (MultiblockRecipe recipe : MultiblockRecipes.getRecipes()) {
            if (recipe.getCatalystStack().func_77973_b() != item) continue;
            return true;
        }
        return false;
    }
}

