/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.misc;

import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.dave.cm2.CompactMachines2;
import org.dave.cm2.utility.Logz;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static File cmDirectory;
    private static final String CATEGORY_INTERNAL = "Internal";
    private static final String CATEGORY_MINIATURIZATION = "Miniaturization";
    private static final String CATEGORY_MACHINES = "Machines";

    public static void init(File configFile) {
        if (configuration != null) {
            return;
        }
        cmDirectory = new File(configFile.getParentFile(), "cm2");
        if (!cmDirectory.exists()) {
            cmDirectory.mkdir();
        }
        configuration = new Configuration(new File(cmDirectory, "settings.cfg"), null);
        ConfigurationHandler.loadConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int extractJarDirectory(String resourcePath, File targetDirectory, boolean overwrite) {
        if (!targetDirectory.exists()) {
            targetDirectory.mkdir();
        }
        Path myPath = null;
        try {
            URI uri = CompactMachines2.class.getResource("/" + resourcePath).toURI();
            if (uri.getScheme().equals("jar")) {
                FileSystem fs = FileSystems.getFileSystem(uri);
                if (fs == null) {
                    fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                myPath = fs.getPath("/" + resourcePath, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
        }
        catch (URISyntaxException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        if (myPath == null) {
            throw new RuntimeException("Could not list files in path: \"" + resourcePath + "\"");
        }
        int count = 0;
        try {
            Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                String filename;
                File targetFile;
                Path path = (Path)it.next();
                String pathWithForeslash = path.toString().replace('\\', '/');
                if (pathWithForeslash.endsWith(resourcePath) || (targetFile = new File(targetDirectory, filename = path.getFileName().toString())).exists() && !overwrite) continue;
                String resourceName = resourcePath + "/" + filename;
                InputStream in = CompactMachines2.class.getClassLoader().getResourceAsStream(resourceName);
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
                    ByteStreams.copy((InputStream)in, (OutputStream)out);
                    ((OutputStream)out).close();
                    in.close();
                    ++count;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to unpack resource '" + resourceName + "'", e);
                    return count;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return count;
    }

    private static void loadConfiguration() {
        Logz.info("Loading configuration", new Object[0]);
        Settings.dimensionId = configuration.getInt("dimensionId", CATEGORY_INTERNAL, 144, Integer.MIN_VALUE, Integer.MAX_VALUE, "Dimension used for machines. Do not change this unless it is somehow conflicting!", "Dimension ID");
        Settings.dimensionTypeId = configuration.getInt("dimensionTypeId", CATEGORY_INTERNAL, 144, Integer.MIN_VALUE, Integer.MAX_VALUE, "Dimension type used for machines. Do not change this unless it is somehow conflicting!", "Dimension Type ID");
        Settings.forceLoadChunks = configuration.getBoolean("forceLoadChunks", CATEGORY_INTERNAL, false, "Whether the interior of all Compact Machines should be chunk loaded always. Otherwise they will only chunkload when the CM itself is chunkloaded.", "Force chunk load");
        Settings.chanceForBrokenCube = configuration.getFloat("worldgenChance", CATEGORY_INTERNAL, 5.0E-4f, 0.0f, 1.0f, "The chance a chunk in the overworld contains a broken compact machine", "Worldgen Chance");
        PotionSettings.onEatAmplifier = configuration.getInt("onEatAmplifier", CATEGORY_MINIATURIZATION, 3, 0, 3, "How strong the 'Shrunk' effect is when applied to entities eating Miniaturization Fluid Drops", "Eating fluid drops - Effect Amplifier");
        PotionSettings.onEatDuration = configuration.getInt("onEatDuration", CATEGORY_MINIATURIZATION, 400, 0, 12000, "How long the 'Shrunk' effect is applied to players, when they eat a Miniaturization Fluid Drop.", "Eating fluid drops - Effect duration");
        PotionSettings.onBlockContactAmplifier = configuration.getInt("onBlockContactAmplifier", CATEGORY_MINIATURIZATION, 1, 0, 3, "How strong the 'Shrunk' effect is when applied to entities touching miniaturization fluid", "Fluid contact - Effect Amplifier");
        PotionSettings.onBlockContactDuration = configuration.getInt("onBlockContactDuration", CATEGORY_MINIATURIZATION, 200, 0, 12000, "How long the 'Shrunk' effect is applied to entities when they touch miniaturization fluid. Set to 0 to disable.", "Fluid contact - Effect duration");
        MachineSettings.allowRespawning = configuration.getBoolean("allowRespawning", CATEGORY_MACHINES, true, "Whether players can respawn inside of Compact Machines, i.e. place beds and sleep there", "Allow Respawning");
        MachineSettings.fluidCostForEntering = configuration.getInt("fluidCostForEntering", CATEGORY_MACHINES, 250, 0, 4000, "How much miniaturization fluid needs to be in the PSD to be able to enter a machine in mB", "Required fluid to enter machine");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void saveConfiguration() {
        Logz.info("Saving configuration", new Object[0]);
        configuration.save();
    }

    @SubscribeEvent
    public void onConfigurationChanged(ConfigChangedEvent event) {
        if (!event.getModID().equalsIgnoreCase("cm2")) {
            return;
        }
        ConfigurationHandler.loadConfiguration();
    }

    public static class Settings {
        public static int dimensionId;
        public static int dimensionTypeId;
        public static boolean forceLoadChunks;
        public static float chanceForBrokenCube;
        private static final String DIMENSION_ID_NAME = "dimensionId";
        private static final int DIMENSION_ID_DEFAULT = 144;
        private static final String DIMENSION_ID_COMMENT = "Dimension used for machines. Do not change this unless it is somehow conflicting!";
        private static final String DIMENSION_ID_LABEL = "Dimension ID";
        private static final String DIMENSION_TYPE_ID_NAME = "dimensionTypeId";
        private static final int DIMENSION_TYPE_ID_DEFAULT = 144;
        private static final String DIMENSION_TYPE_ID_COMMENT = "Dimension type used for machines. Do not change this unless it is somehow conflicting!";
        private static final String DIMENSION_TYPE_ID_LABEL = "Dimension Type ID";
        private static final String FORCELOADCHUNKS_NAME = "forceLoadChunks";
        private static final boolean FORCELOADCHUNKS_DEFAULT = false;
        private static final String FORCELOADCHUNKS_COMMENT = "Whether the interior of all Compact Machines should be chunk loaded always. Otherwise they will only chunkload when the CM itself is chunkloaded.";
        private static final String FORCELOADCHUNKS_LABEL = "Force chunk load";
        private static final String WORLDGEN_CHANCE_NAME = "worldgenChance";
        private static final float WORLDGEN_CHANCE_DEFAULT = 5.0E-4f;
        private static final String WORLDGEN_CHANCE_COMMENT = "The chance a chunk in the overworld contains a broken compact machine";
        private static final String WORLDGEN_CHANCE_LABEL = "Worldgen Chance";
    }

    public static class PotionSettings {
        public static int onBlockContactDuration;
        public static int onBlockContactAmplifier;
        public static int onEatDuration;
        public static int onEatAmplifier;
        private static final String ON_EAT_DURATION_NAME = "onEatDuration";
        private static final int ON_EAT_DURATION_DEFAULT = 400;
        private static final String ON_EAT_DURATION_COMMENT = "How long the 'Shrunk' effect is applied to players, when they eat a Miniaturization Fluid Drop.";
        private static final String ON_EAT_DURATION_LABEL = "Eating fluid drops - Effect duration";
        private static final String ON_EAT_AMPLIFIER_NAME = "onEatAmplifier";
        private static final int ON_EAT_AMPLIFIER_DEFAULT = 3;
        private static final String ON_EAT_AMPLIFIER_COMMENT = "How strong the 'Shrunk' effect is when applied to entities eating Miniaturization Fluid Drops";
        private static final String ON_EAT_AMPLIFIER_LABEL = "Eating fluid drops - Effect Amplifier";
        private static final String OBC_DURATION_NAME = "onBlockContactDuration";
        private static final int OBC_DURATION_DEFAULT = 200;
        private static final String OBC_DURATION_COMMENT = "How long the 'Shrunk' effect is applied to entities when they touch miniaturization fluid. Set to 0 to disable.";
        private static final String OBC_DURATION_LABEL = "Fluid contact - Effect duration";
        private static final String OBC_AMPLIFIER_NAME = "onBlockContactAmplifier";
        private static final int OBC_AMPLIFIER_DEFAULT = 1;
        private static final String OBC_AMPLIFIER_COMMENT = "How strong the 'Shrunk' effect is when applied to entities touching miniaturization fluid";
        private static final String OBC_AMPLIFIER_LABEL = "Fluid contact - Effect Amplifier";
    }

    public static class MachineSettings {
        public static boolean allowRespawning;
        public static int fluidCostForEntering;
        private static final String ALLOW_RESPAWN_NAME = "allowRespawning";
        private static final boolean ALLOW_RESPAWN_DEFAULT = true;
        private static final String ALLOW_RESPAWN_COMMENT = "Whether players can respawn inside of Compact Machines, i.e. place beds and sleep there";
        private static final String ALLOW_RESPAWN_LABEL = "Allow Respawning";
        private static final String FLUID_COST_NAME = "fluidCostForEntering";
        private static final int FLUID_COST_DEFAULT = 250;
        private static final String FLUID_COST_COMMENT = "How much miniaturization fluid needs to be in the PSD to be able to enter a machine in mB";
        private static final String FLUID_COST_LABEL = "Required fluid to enter machine";
    }
}

