/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.misc;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.dave.cm2.block.BlockMachine;
import org.dave.cm2.block.BlockTunnel;
import org.dave.cm2.tile.TileEntityMachine;
import org.dave.cm2.utility.TextFormattingHelper;

public class WailaProvider {
    public static void register(IWailaRegistrar registry) {
        MachineProvider mpInstance = new MachineProvider();
        TunnelProvider tpInstance = new TunnelProvider();
        registry.registerBodyProvider((IWailaDataProvider)mpInstance, BlockMachine.class);
        registry.registerBodyProvider((IWailaDataProvider)tpInstance, BlockTunnel.class);
        registry.registerStackProvider((IWailaDataProvider)mpInstance, BlockMachine.class);
        registry.registerStackProvider((IWailaDataProvider)tpInstance, BlockTunnel.class);
    }

    public static class MachineProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return new ItemStack(accessor.getBlock(), 1, accessor.getMetadata());
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            if (!(accessor.getTileEntity() instanceof TileEntityMachine)) {
                return currenttip;
            }
            String nameOrId = "";
            TileEntityMachine te = (TileEntityMachine)accessor.getTileEntity();
            nameOrId = te.coords < 0 && te.getCustomName().length() == 0 ? I18n.func_135052_a((String)"tooltip.cm2.machine.coords.unused", (Object[])new Object[0]) : (te.getCustomName().length() > 0 ? te.getCustomName() : "#" + te.coords);
            currenttip.add(TextFormattingHelper.colorizeKeyValue(I18n.func_135052_a((String)"tooltip.cm2.machine.coords", (Object[])new Object[]{nameOrId})));
            String sideString = I18n.func_135052_a((String)"enumfacing.side", (Object[])new Object[]{I18n.func_135052_a((String)("enumfacing." + accessor.getSide().func_176610_l()), (Object[])new Object[0])});
            currenttip.add(TextFormattingHelper.colorizeKeyValue(sideString));
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
            return tag;
        }
    }

    public static class TunnelProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return new ItemStack(accessor.getBlock(), 1, 0);
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            String translate = "enumfacing." + ((EnumFacing)accessor.getBlockState().func_177229_b((IProperty)BlockTunnel.MACHINE_SIDE)).func_176610_l();
            currenttip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)translate, (Object[])new Object[0]) + TextFormatting.RESET);
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
            return tag;
        }
    }
}

