/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.tile;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.dave.cm2.block.BlockMachine;
import org.dave.cm2.integration.CapabilityNullHandlerRegistry;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.reference.EnumMachineSize;
import org.dave.cm2.tile.TileEntityTunnel;
import org.dave.cm2.world.ChunkLoadingMachines;
import org.dave.cm2.world.WorldSavedDataMachines;
import org.dave.cm2.world.tools.DimensionTools;
import org.dave.cm2.world.tools.StructureTools;

public class TileEntityMachine
extends TileEntity
implements ICapabilityProvider,
ITickable {
    public int coords = -1;
    private boolean initialized = false;
    public long lastNeighborUpdateTick = 0L;
    protected String customName = "";
    protected UUID owner;

    public EnumMachineSize getSize() {
        return (EnumMachineSize)((Object)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b(BlockMachine.SIZE));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.coords = compound.func_74762_e("coords");
        this.customName = compound.func_74779_i("CustomName");
        this.owner = compound.func_186857_a("owner");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("coords", this.coords);
        compound.func_74778_a("CustomName", this.customName);
        if (this.hasOwner()) {
            compound.func_186854_a("owner", this.owner);
        }
        return compound;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(this.getOwner()).getName();
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setOwner(EntityPlayer player) {
        if (player == null) {
            return;
        }
        this.setOwner(player.func_110124_au());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    private void initialize() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!ChunkLoadingMachines.isMachineChunkLoaded(this.coords)) {
            ChunkLoadingMachines.forceChunk(this.coords);
        }
    }

    public void func_73660_a() {
        if (!this.initialized && !this.func_145837_r() && this.coords != -1) {
            this.initialize();
            this.initialized = true;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (ConfigurationHandler.Settings.forceLoadChunks) {
            return;
        }
        ChunkLoadingMachines.unforceChunk(this.coords);
    }

    public BlockPos getTunnelForSide(EnumFacing side) {
        if (!WorldSavedDataMachines.INSTANCE.tunnels.containsKey(this.coords)) {
            return null;
        }
        return WorldSavedDataMachines.INSTANCE.tunnels.get(this.coords).get(side);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.func_145831_w().field_72995_K || facing == null) {
            if (CapabilityNullHandlerRegistry.hasNullHandler(capability)) {
                return true;
            }
            return super.hasCapability(capability, facing);
        }
        BlockPos tunnelPos = this.getTunnelForSide(facing);
        if (tunnelPos == null) {
            return false;
        }
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        if (!(machineWorld.func_175625_s(tunnelPos) instanceof TileEntityTunnel)) {
            return false;
        }
        EnumFacing insetDirection = StructureTools.getInsetWallFacing(tunnelPos, this.getSize().getDimension());
        BlockPos insetPos = tunnelPos.func_177972_a(insetDirection);
        TileEntity te = machineWorld.func_175625_s(insetPos);
        if (te != null && te instanceof ICapabilityProvider && te.hasCapability(capability, insetDirection.func_176734_d())) {
            return true;
        }
        return CapabilityNullHandlerRegistry.hasNullHandler(capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.func_145831_w().field_72995_K) {
            if (CapabilityNullHandlerRegistry.hasNullHandler(capability)) {
                return CapabilityNullHandlerRegistry.getNullHandler(capability);
            }
            return (T)super.getCapability(capability, facing);
        }
        BlockPos tunnelPos = this.getTunnelForSide(facing);
        if (tunnelPos == null) {
            return null;
        }
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        if (!(machineWorld.func_175625_s(tunnelPos) instanceof TileEntityTunnel)) {
            return null;
        }
        EnumFacing insetDirection = StructureTools.getInsetWallFacing(tunnelPos, this.getSize().getDimension());
        BlockPos insetPos = tunnelPos.func_177972_a(insetDirection);
        TileEntity te = machineWorld.func_175625_s(insetPos);
        if (te instanceof ICapabilityProvider && te.hasCapability(capability, insetDirection.func_176734_d())) {
            return (T)machineWorld.func_175625_s(insetPos).getCapability(capability, insetDirection.func_176734_d());
        }
        if (CapabilityNullHandlerRegistry.hasNullHandler(capability)) {
            return CapabilityNullHandlerRegistry.getNullHandler(capability);
        }
        return null;
    }
}

