/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.dave.cm2.integration.AbstractNullHandler;
import org.dave.cm2.integration.CapabilityNullHandler;
import org.dave.cm2.utility.Logz;

public class AnnotatedInstanceUtil {
    private AnnotatedInstanceUtil() {
    }

    public static List<AbstractNullHandler> getNullHandlers(ASMDataTable asmDataTable) {
        return AnnotatedInstanceUtil.getInstances(asmDataTable, CapabilityNullHandler.class, AbstractNullHandler.class);
    }

    private static <T> List<T> getInstances(ASMDataTable asmDataTable, Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException e) {
                Logz.error("Failed to load: {}", asmData.getClassName(), e);
            }
            catch (IllegalAccessException e) {
                Logz.error("Failed to load: {}", asmData.getClassName(), e);
            }
            catch (InstantiationException e) {
                Logz.error("Failed to load: {}", asmData.getClassName(), e);
            }
            catch (ExceptionInInitializerError e) {
                Logz.error("Failed to load: {}", asmData.getClassName(), e);
            }
        }
        return instances;
    }
}

