/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.world;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import org.dave.cm2.CompactMachines2;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.utility.Logz;
import org.dave.cm2.world.tools.DimensionTools;

public class ChunkLoadingMachines
implements ForgeChunkManager.LoadingCallback {
    public static boolean isMachineChunkLoaded(int coords) {
        if (coords == -1) {
            return false;
        }
        ImmutableSetMultimap existingTickets = ForgeChunkManager.getPersistentChunksFor((World)DimensionTools.getServerMachineWorld());
        ArrayList<Integer> visitedTickets = new ArrayList<Integer>();
        for (ForgeChunkManager.Ticket ticket : existingTickets.values()) {
            if (visitedTickets.contains(ticket.hashCode())) continue;
            visitedTickets.add(ticket.hashCode());
            NBTTagCompound data = ticket.getModData();
            if (!data.func_74764_b("coords")) continue;
            int[] nbtCoords = data.func_74759_k("coords");
            for (int i = 0; i < nbtCoords.length; ++i) {
                if (nbtCoords[i] != coords) continue;
                return true;
            }
        }
        return false;
    }

    public static void unforceChunk(int coord) {
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        ImmutableSetMultimap existingTickets = ForgeChunkManager.getPersistentChunksFor((World)machineWorld);
        ArrayList<Integer> visitedTickets = new ArrayList<Integer>();
        for (ForgeChunkManager.Ticket ticket : existingTickets.values()) {
            if (visitedTickets.contains(ticket.hashCode())) continue;
            visitedTickets.add(ticket.hashCode());
            NBTTagCompound data = ticket.getModData();
            if (!data.func_74764_b("coords")) continue;
            int[] nbtCoords = data.func_74759_k("coords");
            for (int i = 0; i < nbtCoords.length; ++i) {
                if (nbtCoords[i] != coord) continue;
                Logz.debug("ChunkLoading: Runtime: Unforcing chunk for machine: %d", coord);
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(coord << 6, 0));
                int usedChunks = 0;
                if (data.func_74764_b("usedChunks")) {
                    usedChunks = data.func_74762_e("usedChunks");
                }
                if (usedChunks < 2) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                } else {
                    nbtCoords[i] = -1;
                    data.func_74768_a("usedChunks", usedChunks - 1);
                    data.func_74783_a("coords", nbtCoords);
                }
                return;
            }
        }
    }

    public static void forceChunk(int coord) {
        int i;
        ForgeChunkManager.Ticket chunkTicket = null;
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        ImmutableSetMultimap existingTickets = ForgeChunkManager.getPersistentChunksFor((World)machineWorld);
        ArrayList<Integer> visitedTickets = new ArrayList<Integer>();
        for (ForgeChunkManager.Ticket ticket : existingTickets.values()) {
            if (visitedTickets.contains(ticket.hashCode())) continue;
            visitedTickets.add(ticket.hashCode());
            NBTTagCompound data = ticket.getModData();
            if (!data.func_74764_b("coords")) continue;
            int usedChunks = 0;
            if (data.func_74764_b("usedChunks")) {
                usedChunks = data.func_74762_e("usedChunks");
            }
            if (usedChunks >= ticket.getMaxChunkListDepth()) continue;
            chunkTicket = ticket;
            break;
        }
        if (chunkTicket == null) {
            chunkTicket = ForgeChunkManager.requestTicket((Object)CompactMachines2.instance, (World)machineWorld, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        if (chunkTicket == null) {
            return;
        }
        NBTTagCompound data = chunkTicket.getModData();
        int usedChunks = data.func_74764_b("usedChunks") ? data.func_74762_e("usedChunks") : 0;
        int[] nbtCoords = new int[chunkTicket.getMaxChunkListDepth()];
        if (data.func_74764_b("coords")) {
            nbtCoords = data.func_74759_k("coords");
        } else {
            for (i = 0; i < nbtCoords.length; ++i) {
                nbtCoords[i] = -1;
            }
        }
        for (i = 0; i < nbtCoords.length; ++i) {
            if (nbtCoords[i] != -1) continue;
            nbtCoords[i] = coord;
            break;
        }
        data.func_74783_a("coords", nbtCoords);
        data.func_74768_a("usedChunks", usedChunks + 1);
        Logz.debug("ChunkLoading: Runtime: Forcing chunk for machine: %d", coord);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)chunkTicket, (ChunkPos)new ChunkPos(coord << 6, 0));
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (ConfigurationHandler.Settings.forceLoadChunks) {
            Logz.info("Chunkloading is in always mode. Loading all previously loaded chunks.", new Object[0]);
            for (ForgeChunkManager.Ticket ticket : tickets) {
                NBTTagCompound data = ticket.getModData();
                if (!data.func_74764_b("coords")) continue;
                int[] nbtCoords = data.func_74759_k("coords");
                boolean foundMatch = false;
                for (int i = 0; i < nbtCoords.length; ++i) {
                    if (nbtCoords[i] == -1) continue;
                    Logz.debug("ChunkLoading, Tickets Loaded: Forcing chunk for machine: %d", nbtCoords[i]);
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(nbtCoords[i] << 6, 0));
                    foundMatch = true;
                }
                if (foundMatch) continue;
                Logz.debug("ChunkLoading, Tickets Loaded: Ticket %s has no coords stored. Releasing it.", ticket);
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        } else {
            Logz.info("Chunkloading is in smart mode. Releasing previously requested tickets...", new Object[0]);
            for (ForgeChunkManager.Ticket ticket : tickets) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
            return;
        }
    }
}

