/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.world;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.dave.cm2.init.Blockss;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.reference.EnumMachineSize;
import org.dave.cm2.utility.Logz;
import org.dave.cm2.world.tools.StructureTools;

public class WorldGenMachines
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (ConfigurationHandler.Settings.chanceForBrokenCube == 0.0f) {
            return;
        }
        if (random.nextFloat() > ConfigurationHandler.Settings.chanceForBrokenCube) {
            return;
        }
        Logz.debug("Generating cube in overworld: chunkX=%d, chunkZ=%d", chunkX, chunkZ);
        EnumMachineSize size = EnumMachineSize.getFromMeta(random.nextInt(EnumMachineSize.values().length - 3));
        int dim = size.getDimension();
        int x = (chunkX << 4) + random.nextInt(16 - dim) + dim;
        int z = (chunkZ << 4) + random.nextInt(16 - dim) + dim;
        int y = world.func_189649_b(x, z) + dim;
        Biome worldBiome = world.func_180494_b(new BlockPos(x, y, z));
        if (worldBiome == Biomes.field_76771_b || worldBiome == Biomes.field_150575_M || worldBiome == Biomes.field_76776_l) {
            return;
        }
        int cxSphere = x - (random.nextBoolean() ? dim : 0);
        int cySphere = y;
        int czSphere = z - (random.nextBoolean() ? dim : 0);
        int rSphere = dim - random.nextInt(3);
        IBlockState state = Blockss.wallBreakable.func_176223_P();
        IBlockState fluidState = Blockss.miniaturizationFluidBlock.func_176223_P();
        for (BlockPos pos : StructureTools.getCubePositions(new BlockPos(x, y, z), dim + 1, dim + 1, dim + 1, true)) {
            float xx = pos.func_177958_n() - cxSphere;
            float yy = pos.func_177956_o() - cySphere;
            float zz = pos.func_177952_p() - czSphere;
            if (Math.pow(xx, 2.0) + Math.pow(yy, 2.0) + Math.pow(zz, 2.0) < Math.pow(rSphere, 2.0)) continue;
            if (random.nextInt(100) <= 5) {
                world.func_175656_a(pos, fluidState);
                continue;
            }
            world.func_175656_a(pos, state);
        }
    }
}

