/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.world;

import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.utility.DimensionBlockPos;
import org.dave.cm2.utility.Logz;
import org.dave.cm2.world.tools.StructureTools;

public class WorldSavedDataMachines
extends WorldSavedData {
    public int nextCoord = 0;
    public HashMap<Integer, double[]> spawnPoints = new HashMap();
    public HashMap<Integer, HashMap<EnumFacing, BlockPos>> tunnels = new HashMap();
    public HashMap<Integer, DimensionBlockPos> machinePositions = new HashMap();
    public static WorldSavedDataMachines INSTANCE;

    public DimensionBlockPos getMachinePosition(int coord) {
        return this.machinePositions.get(coord);
    }

    public void addMachinePosition(int coord, BlockPos pos, int dimension) {
        this.machinePositions.put(coord, new DimensionBlockPos(pos, dimension));
        Logz.debug("Adding machine position: coords=%d, pos=%s, dimension=%d", coord, pos, dimension);
        this.func_76185_a();
    }

    private void addSpawnPoint(int coord, double[] destination) {
        if (destination.length != 3) {
            Logz.warn("Trying to set spawn point with invalid double[]=%s", new Object[]{destination});
            return;
        }
        this.spawnPoints.put(coord, destination);
        Logz.debug("Setting spawn point: coords=%d, x=%.2f, y=%.2f, z=%.2f", coord, destination[0], destination[1], destination[2]);
        this.func_76185_a();
    }

    public void addSpawnPoint(int coord, double x, double y, double z) {
        this.addSpawnPoint(coord, new double[]{x, y, z});
    }

    public void removeMachinePosition(int coord) {
        this.machinePositions.remove(coord);
        Logz.debug("Removing machine position by coord: coords=%d", coord);
        this.func_76185_a();
    }

    public static int reserveMachineId() {
        int val = WorldSavedDataMachines.INSTANCE.nextCoord++;
        INSTANCE.func_76185_a();
        return val;
    }

    public WorldSavedDataMachines(String name) {
        super(name);
    }

    @SubscribeEvent
    public static void loadWorld(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K || event.getWorld().field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
            return;
        }
        Logz.info("Loading saved data for machine world", new Object[0]);
        WorldSavedDataMachines wsd = (WorldSavedDataMachines)event.getWorld().func_175693_T().func_75742_a(WorldSavedDataMachines.class, "WorldSavedDataMachines");
        if (wsd == null) {
            wsd = new WorldSavedDataMachines("WorldSavedDataMachines");
            wsd.func_76185_a();
        }
        Logz.info(" > %d spawn points", wsd.spawnPoints.size());
        Logz.info(" > Next machine id: %d", wsd.nextCoord);
        INSTANCE = wsd;
        event.getWorld().func_175693_T().func_75745_a("WorldSavedDataMachines", (WorldSavedData)wsd);
    }

    public void removeTunnel(BlockPos pos) {
        int coords = StructureTools.getCoordsForPos(pos);
        HashMap<EnumFacing, BlockPos> sideMapping = this.tunnels.get(coords);
        if (sideMapping == null) {
            return;
        }
        EnumFacing sideToRemove = null;
        for (EnumFacing side : sideMapping.keySet()) {
            if (!sideMapping.get(side).equals((Object)pos)) continue;
            sideToRemove = side;
            break;
        }
        if (sideToRemove != null) {
            Logz.debug("Removing tunnel mapping by blockpos: pos=%s --> coords=%d, side=%s", pos, coords, sideToRemove);
            sideMapping.remove(sideToRemove);
        }
        this.func_76185_a();
    }

    public void removeTunnel(BlockPos position, EnumFacing side) {
        int coords = StructureTools.getCoordsForPos(position);
        HashMap<EnumFacing, BlockPos> sideMapping = this.tunnels.get(coords);
        if (sideMapping == null) {
            return;
        }
        Logz.debug("Removing tunnel mapping by pos+side: coords=%d, side=%s", coords, side);
        sideMapping.remove(side);
        this.func_76185_a();
    }

    public void addTunnel(BlockPos position, EnumFacing side) {
        this.addTunnel(position, side, false);
    }

    private void addTunnel(BlockPos position, EnumFacing side, boolean isLoading) {
        int coords = StructureTools.getCoordsForPos(position);
        HashMap<Object, Object> sideMapping = this.tunnels.get(coords);
        if (sideMapping == null) {
            sideMapping = new HashMap();
            this.tunnels.put(coords, sideMapping);
        }
        sideMapping.put(side, position);
        Logz.debug("Adding tunnel mapping: side=%s, pos=%s --> coords=%d", side, position, coords);
        if (!isLoading) {
            this.func_76185_a();
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("nextMachineCoord", this.nextCoord);
        NBTTagList spawnPointList = new NBTTagList();
        for (int coords : this.spawnPoints.keySet()) {
            double[] positions = this.spawnPoints.get(coords);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("coords", coords);
            tag.func_74780_a("x", positions[0]);
            tag.func_74780_a("y", positions[1]);
            tag.func_74780_a("z", positions[2]);
            spawnPointList.func_74742_a((NBTBase)tag);
        }
        NBTTagList tunnelList = new NBTTagList();
        for (int coords : this.tunnels.keySet()) {
            HashMap<EnumFacing, BlockPos> sideMappings = this.tunnels.get(coords);
            for (EnumFacing side : sideMappings.keySet()) {
                BlockPos position = sideMappings.get(side);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("side", side.func_176745_a());
                tag.func_74768_a("x", position.func_177958_n());
                tag.func_74768_a("y", position.func_177956_o());
                tag.func_74768_a("z", position.func_177952_p());
                tunnelList.func_74742_a((NBTBase)tag);
            }
        }
        NBTTagList machineList = new NBTTagList();
        for (int coords : this.machinePositions.keySet()) {
            DimensionBlockPos dimpos = this.machinePositions.get(coords);
            BlockPos position = dimpos.getBlockPos();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("coords", coords);
            tag.func_74768_a("x", position.func_177958_n());
            tag.func_74768_a("y", position.func_177956_o());
            tag.func_74768_a("z", position.func_177952_p());
            tag.func_74768_a("dim", dimpos.getDimension());
            machineList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("spawnpoints", (NBTBase)spawnPointList);
        compound.func_74782_a("tunnels", (NBTBase)tunnelList);
        compound.func_74782_a("machines", (NBTBase)machineList);
        return compound;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagCompound tag;
        int i;
        NBTTagList tagList;
        this.nextCoord = nbt.func_74762_e("nextMachineCoord");
        if (nbt.func_74764_b("spawnpoints")) {
            this.spawnPoints.clear();
            tagList = nbt.func_150295_c("spawnpoints", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                int coords = tag.func_74762_e("coords");
                double[] positions = new double[]{tag.func_74769_h("x"), tag.func_74769_h("y"), tag.func_74769_h("z")};
                this.spawnPoints.put(coords, positions);
            }
        }
        if (nbt.func_74764_b("tunnels")) {
            this.tunnels.clear();
            tagList = nbt.func_150295_c("tunnels", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                BlockPos position = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                EnumFacing side = EnumFacing.func_82600_a((int)tag.func_74762_e("side"));
                this.addTunnel(position, side, true);
            }
        }
        if (nbt.func_74764_b("machines")) {
            this.machinePositions.clear();
            tagList = nbt.func_150295_c("machines", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                BlockPos position = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                this.machinePositions.put(tag.func_74762_e("coords"), new DimensionBlockPos(position, tag.func_74762_e("dim")));
            }
        }
    }
}

