/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.world.tools;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RecursiveSearch {
    private HashMap<BlockPos, Boolean> visited = new HashMap();
    private ArrayList<BlockPos> result = new ArrayList();
    private World world;
    private Block type;
    private int limit = 2048;
    private int lowestY = -1;
    private boolean matchBlock = true;
    private BlockPos startPos;

    public RecursiveSearch(World world, BlockPos pos, Block type, int lowestY, boolean matchBlock) {
        this.world = world;
        this.type = type;
        this.lowestY = lowestY;
        this.matchBlock = matchBlock;
        this.startPos = pos;
        this.getConnectedBlocks(pos);
    }

    public void getConnectedBlocks(BlockPos pos) {
        if (this.visited.getOrDefault(pos, false).booleanValue()) {
            return;
        }
        if (this.lowestY != -1 && pos.func_177956_o() < this.lowestY) {
            return;
        }
        this.visited.put(pos, true);
        --this.limit;
        if (this.limit <= 0) {
            return;
        }
        IBlockState state = this.world.func_180495_p(pos);
        if (this.matchBlock && state.func_177230_c() != this.type) {
            return;
        }
        if (!this.matchBlock && state.func_177230_c() == this.type) {
            return;
        }
        if (!state.func_177230_c().isAir(state, (IBlockAccess)this.world, pos)) {
            this.result.add(pos);
        }
        for (EnumFacing direction : EnumFacing.values()) {
            this.getConnectedBlocks(pos.func_177972_a(direction));
        }
    }

    public ArrayList<BlockPos> getResult() {
        return this.result;
    }
}

