/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.world.tools;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.dave.cm2.init.Blockss;
import org.dave.cm2.schema.BlockInformation;
import org.dave.cm2.tile.TileEntityMachine;
import org.dave.cm2.utility.Logz;
import org.dave.cm2.world.WorldSavedDataMachines;
import org.dave.cm2.world.tools.DimensionTools;

public class StructureTools {
    public static int getCoordsForPos(BlockPos pos) {
        return StructureTools.getCoordsForPos(pos.func_177958_n());
    }

    public static int getCoordsForPos(int x) {
        return x >> 10;
    }

    public static EnumFacing getNextDirection(EnumFacing in) {
        switch (in) {
            case DOWN: {
                return EnumFacing.UP;
            }
            case UP: {
                return EnumFacing.NORTH;
            }
            case NORTH: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return null;
            }
        }
        return null;
    }

    public static void generateCubeForMachine(TileEntityMachine machine) {
        if (machine.coords != -1) {
            return;
        }
        machine.coords = WorldSavedDataMachines.reserveMachineId();
        Logz.info("Reserved id %d for machine", machine.coords);
        machine.func_70296_d();
        StructureTools.generateCube(machine);
    }

    private static void generateCube(TileEntityMachine machine) {
        int size = machine.getSize().getDimension();
        int startX = machine.coords * 1024 + size;
        int startY = 40 + size;
        int startZ = size;
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        IBlockState state = Blockss.wall.func_176223_P();
        StructureTools.generateCube((World)machineWorld, new BlockPos(startX, startY, startZ), size, state);
    }

    public static void generateCube(World world, BlockPos cornerPos, int size, IBlockState state) {
        for (BlockPos pos : StructureTools.getCubePositions(cornerPos, size + 1, size + 1, size + 1, true)) {
            world.func_175656_a(pos, state);
        }
    }

    public static EnumFacing getInsetWallFacing(BlockPos wallPos, int size) {
        int x = wallPos.func_177958_n() % 1024;
        int y = wallPos.func_177956_o();
        int z = wallPos.func_177952_p();
        if (y == 40) {
            return EnumFacing.UP;
        }
        if (y == 40 + size) {
            return EnumFacing.DOWN;
        }
        if (x == 0) {
            return EnumFacing.EAST;
        }
        if (x == 0 + size) {
            return EnumFacing.WEST;
        }
        if (z == 0) {
            return EnumFacing.SOUTH;
        }
        return EnumFacing.NORTH;
    }

    public static List<BlockPos> getCubePositions(BlockPos cornerPos, int width, int height, int depth, boolean includeFloor) {
        int minX = Math.min(cornerPos.func_177958_n(), cornerPos.func_177958_n() - (width - 1));
        int minY = Math.min(cornerPos.func_177956_o(), cornerPos.func_177956_o() - (height - 1));
        int minZ = Math.min(cornerPos.func_177952_p(), cornerPos.func_177952_p() - (depth - 1));
        int maxX = Math.max(cornerPos.func_177958_n(), cornerPos.func_177958_n() - (width - 1));
        int maxY = Math.max(cornerPos.func_177956_o(), cornerPos.func_177956_o() - (height - 1));
        int maxZ = Math.max(cornerPos.func_177952_p(), cornerPos.func_177952_p() - (depth - 1));
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && z != minZ && x != maxX && y != maxY && z != maxZ && (y != minY || !includeFloor)) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    list.add(pos);
                }
            }
        }
        return list;
    }

    public static List<BlockInformation> getSchema(int coords) {
        TileEntity machine = WorldSavedDataMachines.INSTANCE.getMachinePosition(coords).getTileEntity();
        if (machine != null && machine instanceof TileEntityMachine) {
            return StructureTools.getSchema((TileEntityMachine)machine);
        }
        return null;
    }

    public static List<BlockInformation> getSchema(TileEntityMachine machine) {
        ArrayList<BlockInformation> blockList = new ArrayList<BlockInformation>();
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        int size = machine.getSize().getDimension();
        int startX = machine.coords * 1024 + size;
        int startY = 40 + size;
        int startZ = size;
        for (int x = 1; x <= size - 1; ++x) {
            for (int y = 1; y <= size - 1; ++y) {
                for (int z = 1; z <= size - 1; ++z) {
                    BlockPos absolutePos = new BlockPos(startX - x, startY - y, startZ - z);
                    BlockPos relativePos = new BlockPos(x - 1, y - 1, z - 1);
                    if (machineWorld.func_175623_d(absolutePos)) continue;
                    IBlockState state = machineWorld.func_180495_p(absolutePos);
                    Block block = state.func_177230_c();
                    NBTTagCompound nbt = null;
                    boolean writePositionData = false;
                    if (block.hasTileEntity(state)) {
                        boolean storedZ;
                        TileEntity te = machineWorld.func_175625_s(absolutePos);
                        nbt = new NBTTagCompound();
                        te.func_189515_b(nbt);
                        boolean storedX = nbt.func_74764_b("x") && nbt.func_74762_e("x") == absolutePos.func_177958_n();
                        boolean storedY = nbt.func_74764_b("y") && nbt.func_74762_e("y") == absolutePos.func_177956_o();
                        boolean bl = storedZ = nbt.func_74764_b("z") && nbt.func_74762_e("z") == absolutePos.func_177952_p();
                        if (storedX && storedY && storedZ) {
                            writePositionData = true;
                        }
                    }
                    blockList.add(new BlockInformation(relativePos, block, block.func_176201_c(state), nbt, writePositionData));
                }
            }
        }
        return blockList;
    }
}

