/*
 * Decompiled with CFR 0.152.
 */
package org.dave.cm2.world.tools;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.dave.cm2.misc.ConfigurationHandler;
import org.dave.cm2.tile.TileEntityMachine;
import org.dave.cm2.world.TeleporterMachines;
import org.dave.cm2.world.WorldSavedDataMachines;
import org.dave.cm2.world.tools.DimensionTools;
import org.dave.cm2.world.tools.StructureTools;

public class TeleportationTools {
    private static void teleportPlayerToMachine(EntityPlayerMP player, int coords, boolean isReturning) {
        NBTTagCompound playerNBT = player.getEntityData();
        if (player.field_71093_bK != ConfigurationHandler.Settings.dimensionId) {
            playerNBT.func_74768_a("cm2-oldDimension", player.field_71093_bK);
            playerNBT.func_74780_a("cm2-oldPosX", player.field_70165_t);
            playerNBT.func_74780_a("cm2-oldPosY", player.field_70163_u);
            playerNBT.func_74780_a("cm2-oldPosZ", player.field_70161_v);
            WorldServer machineWorld = DimensionTools.getServerMachineWorld();
            PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            playerList.transferPlayerToDimension(player, ConfigurationHandler.Settings.dimensionId, (Teleporter)new TeleporterMachines(machineWorld));
            if (playerNBT.func_74764_b("cm2-coordHistory")) {
                playerNBT.func_82580_o("cm2-coordHistory");
            }
        }
        if (!isReturning) {
            NBTTagList coordHistory = playerNBT.func_74764_b("cm2-coordHistory") ? playerNBT.func_150295_c("cm2-coordHistory", 10) : new NBTTagList();
            NBTTagCompound toAppend = new NBTTagCompound();
            toAppend.func_74768_a("coord", coords);
            coordHistory.func_74742_a((NBTBase)toAppend);
            playerNBT.func_74782_a("cm2-coordHistory", (NBTBase)coordHistory);
        }
        double[] destination = WorldSavedDataMachines.INSTANCE.spawnPoints.get(coords);
        player.func_70634_a(destination[0], destination[1], destination[2]);
    }

    private static void teleportPlayerOutOfMachineDimension(EntityPlayerMP player) {
        PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        NBTTagCompound playerNBT = player.getEntityData();
        if (playerNBT.func_74764_b("cm2-oldPosX")) {
            int oldDimension = playerNBT.func_74762_e("cm2-oldDimension");
            double oldPosX = playerNBT.func_74769_h("cm2-oldPosX");
            double oldPosY = playerNBT.func_74769_h("cm2-oldPosY");
            double oldPosZ = playerNBT.func_74769_h("cm2-oldPosZ");
            playerList.transferPlayerToDimension(player, oldDimension, (Teleporter)new TeleporterMachines(DimensionTools.getWorldServerForDimension(oldDimension)));
            player.func_70634_a(oldPosX, oldPosY, oldPosZ);
        } else {
            BlockPos spawnPoint = DimensionTools.getWorldServerForDimension((int)0).field_73011_w.getRandomizedSpawnPoint();
            playerList.transferPlayerToDimension(player, 0, (Teleporter)new TeleporterMachines(DimensionTools.getWorldServerForDimension(0)));
            player.func_70634_a((double)spawnPoint.func_177958_n(), (double)spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p());
        }
    }

    public static void teleportPlayerToMachine(EntityPlayerMP player, TileEntityMachine machine) {
        if (machine.coords == -1) {
            StructureTools.generateCubeForMachine(machine);
            double[] destination = new double[]{(double)(machine.coords * 1024) + 0.5 + (double)(machine.getSize().getDimension() / 2), 42.0, 0.5 + (double)(machine.getSize().getDimension() / 2)};
            double x = (double)(machine.coords * 1024) + 0.5 + (double)(machine.getSize().getDimension() / 2);
            double y = 42.0;
            double z = 0.5 + (double)(machine.getSize().getDimension() / 2);
            WorldSavedDataMachines.INSTANCE.addSpawnPoint(machine.coords, x, y, z);
        }
        TeleportationTools.teleportPlayerToMachine(player, machine.coords, false);
    }

    public static void teleportPlayerOutOfMachine(EntityPlayerMP player) {
        NBTTagCompound playerNBT = player.getEntityData();
        if (!playerNBT.func_74764_b("cm2-coordHistory")) {
            return;
        }
        NBTTagList coordHistory = playerNBT.func_150295_c("cm2-coordHistory", 10);
        if (coordHistory.func_74745_c() == 0) {
            TeleportationTools.teleportPlayerOutOfMachineDimension(player);
            return;
        }
        coordHistory.func_74744_a(coordHistory.func_74745_c() - 1);
        if (coordHistory.func_74745_c() == 0) {
            TeleportationTools.teleportPlayerOutOfMachineDimension(player);
            return;
        }
        int coords = coordHistory.func_150305_b(coordHistory.func_74745_c() - 1).func_74762_e("coord");
        TeleportationTools.teleportPlayerToMachine(player, coords, true);
    }
}

