/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.network;

import io.netty.buffer.ByteBuf;
import mcmultipart.item.PartPlacementWrapper;
import mcmultipart.network.MultipartNetworkHandler;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageWrappedPartPlacement
implements IMessage,
IMessageHandler<MessageWrappedPartPlacement, MessageWrappedPartPlacement> {
    private String wrapper;
    private EnumHand hand;

    public MessageWrappedPartPlacement(String handler, EnumHand hand) {
        this.wrapper = handler;
        this.hand = hand;
    }

    public MessageWrappedPartPlacement() {
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.wrapper);
        buf.writeInt(this.hand.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        this.wrapper = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.hand = EnumHand.values()[buf.readInt()];
    }

    public MessageWrappedPartPlacement onMessage(final MessageWrappedPartPlacement message, final MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    MessageWrappedPartPlacement.handlePacket(message, (EntityPlayer)ctx.getServerHandler().field_147369_b);
                }
            });
        }
        return null;
    }

    private static void handlePacket(MessageWrappedPartPlacement message, EntityPlayer player) {
        World world = player.field_70170_p;
        RayTraceResult mop = world.func_72933_a(RayTraceUtils.getStart(player), RayTraceUtils.getEnd(player));
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = mop.func_178782_a();
        EnumFacing side = mop.field_178784_b;
        Vec3d hit = mop.field_72307_f.func_178788_d(new Vec3d((Vec3i)mop.func_178782_a()));
        ItemStack stack = player.func_184586_b(message.hand);
        if (PartPlacementWrapper.getWrapper(message.wrapper).doPlace(world, pos, side, hit, stack, player)) {
            player.func_184609_a(message.hand);
        }
    }

    public void send() {
        MultipartNetworkHandler.sendToServer(this);
    }
}

