/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.inventory.SlotHandleClicks;
import codechicken.lib.packet.PacketCustom;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerExtended
extends Container
implements IContainerListener {
    public LinkedList<EntityPlayerMP> playerCrafters = new LinkedList();

    public ContainerExtended() {
        this.field_75149_d.add(this);
    }

    public void func_75132_a(IContainerListener icrafting) {
        if (icrafting instanceof EntityPlayerMP) {
            this.playerCrafters.add((EntityPlayerMP)icrafting);
            this.sendContainerAndContentsToPlayer(this, this.func_75138_a(), Arrays.asList((EntityPlayerMP)icrafting));
            this.func_75142_b();
        } else {
            super.func_75132_a(icrafting);
        }
    }

    public void func_82847_b(IContainerListener icrafting) {
        if (icrafting instanceof EntityPlayerMP) {
            this.playerCrafters.remove(icrafting);
        } else {
            super.func_82847_b(icrafting);
        }
    }

    public void func_71110_a(Container container, List list) {
        this.sendContainerAndContentsToPlayer(container, list, this.playerCrafters);
    }

    public void func_175173_a(Container p_175173_1_, IInventory p_175173_2_) {
    }

    public void sendContainerAndContentsToPlayer(Container container, List<ItemStack> list, List<EntityPlayerMP> playerCrafters) {
        ItemStack stack;
        LinkedList<ItemStack> largeStacks = new LinkedList<ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            stack = list.get(i);
            if (stack != null && stack.field_77994_a > 127) {
                list.set(i, null);
                largeStacks.add(stack);
                continue;
            }
            largeStacks.add(null);
        }
        for (EntityPlayerMP player : playerCrafters) {
            player.func_71110_a(container, list);
        }
        for (int i = 0; i < largeStacks.size(); ++i) {
            stack = (ItemStack)largeStacks.get(i);
            if (stack == null) continue;
            this.sendLargeStack(stack, i, playerCrafters);
        }
    }

    public void sendLargeStack(ItemStack stack, int slot, List<EntityPlayerMP> players) {
    }

    public void func_71112_a(Container container, int i, int j) {
        for (EntityPlayerMP player : this.playerCrafters) {
            player.func_71112_a(container, i, j);
        }
    }

    public void func_71111_a(Container container, int slot, ItemStack stack) {
        if (stack != null && stack.field_77994_a > 127) {
            this.sendLargeStack(stack, slot, this.playerCrafters);
        } else {
            for (EntityPlayerMP player : this.playerCrafters) {
                player.func_71111_a(container, slot, stack);
            }
        }
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickType, EntityPlayer player) {
        Slot actualSlot;
        if (slot >= 0 && slot < this.field_75151_b.size() && (actualSlot = this.func_75139_a(slot)) instanceof SlotHandleClicks) {
            return ((SlotHandleClicks)actualSlot).slotClick(this, player, dragType, clickType);
        }
        return super.func_184996_a(slot, dragType, clickType, player);
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotIndex) {
        ItemStack transferredStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            transferredStack = stack.func_77946_l();
            if (!this.doMergeStackAreas(slotIndex, stack)) {
                return null;
            }
            if (stack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return transferredStack;
    }

    public boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        Slot slot;
        int slotIndex;
        boolean merged = false;
        int n = slotIndex = reverse ? endIndex - 1 : startIndex;
        if (stack == null) {
            return false;
        }
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                ItemStack slotStack = slot.func_75211_c();
                if (slotStack != null && slotStack.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77952_i() == slotStack.func_77952_i()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotStack)) {
                    int totalStackSize = slotStack.field_77994_a + stack.field_77994_a;
                    int maxStackSize = Math.min(stack.func_77976_d(), slot.func_75219_a());
                    if (totalStackSize <= maxStackSize) {
                        stack.field_77994_a = 0;
                        slotStack.field_77994_a = totalStackSize;
                        slot.func_75218_e();
                        merged = true;
                    } else if (slotStack.field_77994_a < maxStackSize) {
                        stack.field_77994_a -= maxStackSize - slotStack.field_77994_a;
                        slotStack.field_77994_a = maxStackSize;
                        slot.func_75218_e();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        if (stack.field_77994_a > 0) {
            int n2 = slotIndex = reverse ? endIndex - 1 : startIndex;
            while (stack.field_77994_a > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                if (!slot.func_75216_d() && slot.func_75214_a(stack)) {
                    int maxStackSize = Math.min(stack.func_77976_d(), slot.func_75219_a());
                    if (stack.field_77994_a <= maxStackSize) {
                        slot.func_75215_d(stack.func_77946_l());
                        slot.func_75218_e();
                        stack.field_77994_a = 0;
                        merged = true;
                    } else {
                        slot.func_75215_d(stack.func_77979_a(maxStackSize));
                        slot.func_75218_e();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        return merged;
    }

    public boolean doMergeStackAreas(int slotIndex, ItemStack stack) {
        return false;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        this.bindPlayerInventory(inventoryPlayer, 8, 84);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, slot, x + slot * 18, y + 58));
        }
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    public void sendContainerPacket(PacketCustom packet) {
        for (EntityPlayerMP player : this.playerCrafters) {
            packet.sendToPlayer((EntityPlayer)player);
        }
    }

    public void handleOutputPacket(PacketCustom packet) {
    }

    public void handleInputPacket(PacketCustom packet) {
    }

    public void handleGuiChange(int ID, int value) {
    }

    public void sendProgressBarUpdate(int barID, int value) {
        for (IContainerListener crafting : this.field_75149_d) {
            crafting.func_71112_a((Container)this, barID, value);
        }
    }
}

