/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.itemconfig;

import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.DoubleConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IConfigurableItem;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IntegerConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ToolConfigHelper {
    public static int getProfile(ItemStack stack) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("ToolProfile")) {
            return 0;
        }
        return stack.func_77978_p().func_74771_c("ToolProfile");
    }

    public static String getProfileName(ItemStack stack, int profile) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("ToolProfileName" + profile)) {
            return "Profile " + (profile + 1);
        }
        return stack.func_77978_p().func_74779_i("ToolProfileName" + profile);
    }

    public static void setProfileName(ItemStack stack, int profile, String name) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("ToolProfileName" + profile, name);
    }

    public static void incrementProfile(ItemStack stack) {
        IConfigurableItem item = ToolConfigHelper.getTool(stack);
        if (item == null || item.getProfileCount(stack) == 1) {
            return;
        }
        int profile = ToolConfigHelper.getProfile(stack);
        if (++profile >= item.getProfileCount(stack)) {
            profile = 0;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74774_a("ToolProfile", (byte)profile);
    }

    public static NBTTagCompound getFieldStorage(ItemStack stack) {
        String tag = "Profile_" + ToolConfigHelper.getProfile(stack);
        return stack.func_179543_a(tag, true);
    }

    public static boolean getBooleanField(String fieldName, ItemStack stack) {
        IConfigurableItem item = ToolConfigHelper.getTool(stack);
        if (item == null) {
            return false;
        }
        ItemConfigFieldRegistry fieldRegistry = item.getFields(stack, new ItemConfigFieldRegistry());
        if (fieldRegistry.getField(fieldName) == null) {
            return false;
        }
        IItemConfigField field = fieldRegistry.getField(fieldName);
        if (field instanceof BooleanConfigField) {
            field.readFromNBT(ToolConfigHelper.getFieldStorage(stack));
            return (Integer)field.getValue() == 1;
        }
        return false;
    }

    public static int getIntegerField(String fieldName, ItemStack stack) {
        IConfigurableItem item = ToolConfigHelper.getTool(stack);
        if (item == null) {
            return 0;
        }
        ItemConfigFieldRegistry fieldRegistry = item.getFields(stack, new ItemConfigFieldRegistry());
        if (fieldRegistry.getField(fieldName) == null) {
            return 0;
        }
        IItemConfigField field = fieldRegistry.getField(fieldName);
        if (field instanceof IntegerConfigField) {
            field.readFromNBT(ToolConfigHelper.getFieldStorage(stack));
            return (Integer)field.getValue();
        }
        return 0;
    }

    public static double getDoubleField(String fieldName, ItemStack stack) {
        IConfigurableItem item = ToolConfigHelper.getTool(stack);
        if (item == null) {
            return 0.0;
        }
        ItemConfigFieldRegistry fieldRegistry = item.getFields(stack, new ItemConfigFieldRegistry());
        if (fieldRegistry.getField(fieldName) == null) {
            return 0.0;
        }
        IItemConfigField field = fieldRegistry.getField(fieldName);
        if (field instanceof DoubleConfigField) {
            field.readFromNBT(ToolConfigHelper.getFieldStorage(stack));
            return (Double)field.getValue();
        }
        return 0.0;
    }

    private static IConfigurableItem getTool(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof IConfigurableItem)) {
            return null;
        }
        return (IConfigurableItem)stack.func_77973_b();
    }
}

