/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileInventoryBase;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.network.PacketTileMessage;
import com.brandon3055.brandonscore.network.wrappers.SyncableBool;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableShort;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.fusioncrafting.ICraftingPedestal;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.EffectTrackerFusionCrafting;
import com.brandon3055.draconicevolution.client.sound.FusionRotationSound;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import com.brandon3055.draconicevolution.lib.RecipeManager;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileFusionCraftingCore
extends TileInventoryBase
implements IFusionCraftingInventory,
ITickable,
ISidedInventory {
    public List<ICraftingPedestal> pedestals = new ArrayList<ICraftingPedestal>();
    public final SyncableBool isCrafting = new SyncableBool(false, true, false, true);
    public final SyncableShort craftingStage = new SyncableShort(0, true, false, false);
    public IFusionRecipe activeRecipe = null;
    private int craftingSpeedBoost = 0;
    protected IItemHandler[] itemHandlers = new IItemHandler[6];
    @SideOnly(value=Side.CLIENT)
    public LinkedList<EffectTrackerFusionCrafting> effects;
    private double effectRotation;
    private boolean allLocked;
    private boolean halfCycle;

    public TileFusionCraftingCore() {
        for (EnumFacing facing : EnumFacing.values()) {
            this.itemHandlers[facing.func_176745_a()] = new SidedInvWrapper((ISidedInventory)this, facing);
        }
        this.effectRotation = 0.0;
        this.allLocked = false;
        this.halfCycle = false;
        this.setInventorySize(2);
        this.registerSyncableObject((SyncableObject)this.isCrafting, true);
        this.registerSyncableObject((SyncableObject)this.craftingStage, false);
        this.setShouldRefreshOnBlockChange();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.detectAndSendChanges();
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateEffects();
            return;
        }
        if (this.isCrafting.value) {
            if (DEEventHandler.serverTicks % 10 == 0) {
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            }
            for (ICraftingPedestal pedestal : this.pedestals) {
                if (!((TileEntity)pedestal).func_145837_r()) continue;
                this.invalidateCrafting();
                return;
            }
            if (this.activeRecipe == null || !this.activeRecipe.matches(this, this.field_145850_b, this.field_174879_c) || this.activeRecipe.canCraft(this, this.field_145850_b, this.field_174879_c) == null || !this.activeRecipe.canCraft(this, this.field_145850_b, this.field_174879_c).equals("true")) {
                this.invalidateCrafting();
                return;
            }
            long totalCharge = 0L;
            for (ICraftingPedestal pedestal : this.pedestals) {
                if (pedestal.getStackInPedestal() == null) continue;
                totalCharge += (long)pedestal.getCharge();
            }
            int averageCharge = (int)(totalCharge / (long)this.activeRecipe.getRecipeIngredients().size());
            double percentage = (double)averageCharge / (double)this.activeRecipe.getEnergyCost();
            if (percentage <= 1.0 && this.craftingStage.value < 1000) {
                this.craftingStage.value = (short)(percentage * 1000.0);
                if (this.craftingStage.value == 0 && percentage > 0.0) {
                    this.craftingStage.value = 1;
                }
            } else if (this.craftingStage.value < 2000) {
                this.craftingStage.value = (short)(this.craftingStage.value + (2 + this.craftingSpeedBoost));
            } else if (this.craftingStage.value >= 2000) {
                this.activeRecipe.craft(this, this.field_145850_b, this.field_174879_c);
                for (ICraftingPedestal pedestal : this.pedestals) {
                    pedestal.onCraft();
                }
                this.isCrafting.value = false;
            }
        } else if (this.craftingStage.value > 0) {
            this.craftingStage.value = 0;
        }
    }

    public void attemptStartCrafting() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        LogHelper.dev("FusionCrafting: Try Start Crafting");
        this.updatePedestals();
        this.activeRecipe = RecipeManager.FUSION_REGISTRY.findRecipe(this, this.field_145850_b, this.field_174879_c);
        if (this.activeRecipe != null && this.activeRecipe.canCraft(this, this.field_145850_b, this.field_174879_c) != null && this.activeRecipe.canCraft(this, this.field_145850_b, this.field_174879_c).equals("true")) {
            int minTier = 3;
            for (ICraftingPedestal pedestal : this.pedestals) {
                if (pedestal.getStackInPedestal() != null && pedestal.getPedestalTier() < minTier) {
                    minTier = pedestal.getPedestalTier();
                }
                this.craftingSpeedBoost = minTier == 0 ? 0 : (minTier == 1 ? 1 : (minTier == 2 ? 3 : (minTier == 3 ? 5 : 0)));
            }
            this.isCrafting.value = true;
        } else {
            this.activeRecipe = null;
        }
    }

    private void invalidateCrafting() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        LogHelper.dev("FusionCrafting: Invalidate Crafting");
        this.isCrafting.value = false;
        this.activeRecipe = null;
        this.craftingStage.value = 0;
        this.pedestals.clear();
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
    }

    public void updatePedestals() {
        if (this.isCrafting.value) {
            return;
        }
        LogHelper.dev("FusionCrafting: Update Injectors");
        this.pedestals.clear();
        int range = 16;
        ArrayList positions = new ArrayList();
        positions.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-range, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(range, 1, 1))));
        positions.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-1, -range, -1), (BlockPos)this.field_174879_c.func_177982_a(1, range, 1))));
        positions.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -range), (BlockPos)this.field_174879_c.func_177982_a(1, 1, range))));
        for (BlockPos checkPos : positions) {
            TileEntity tile = this.field_145850_b.func_175625_s(checkPos);
            if (!(tile instanceof ICraftingPedestal)) continue;
            ICraftingPedestal pedestal = (ICraftingPedestal)tile;
            Vec3D dirVec = new Vec3D(tile.func_174877_v()).subtract(this.field_174879_c);
            double dist = Utils.getDistanceAtoB((Vec3D)new Vec3D(tile.func_174877_v()), (Vec3D)new Vec3D(this.field_174879_c));
            if (!(dist >= 2.0) || EnumFacing.func_176737_a((float)((int)dirVec.x), (float)((int)dirVec.y), (float)((int)dirVec.z)) != pedestal.getDirection().func_176734_d() || !pedestal.setCraftingInventory(this)) continue;
            BlockPos pPos = tile.func_174877_v();
            EnumFacing facing = pedestal.getDirection();
            ArrayList checkList = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)pPos.func_177972_a(facing), (BlockPos)pPos.func_177967_a(facing, FacingUtils.destanceInDirection((BlockPos)pPos, (BlockPos)this.field_174879_c, (EnumFacing)facing) - 1)));
            boolean obstructed = false;
            for (BlockPos bp : checkList) {
                if (this.field_145850_b.func_175623_d(bp) || !this.field_145850_b.func_180495_p(bp).func_185917_h() && !(this.field_145850_b.func_175625_s(bp) instanceof ICraftingPedestal)) continue;
                obstructed = true;
                break;
            }
            if (!obstructed) {
                this.pedestals.add(pedestal);
                continue;
            }
            pedestal.setCraftingInventory(null);
        }
    }

    @Override
    public boolean craftingInProgress() {
        return this.isCrafting.value;
    }

    public void receivePacketFromClient(PacketTileMessage packet, EntityPlayerMP client) {
        this.attemptStartCrafting();
    }

    @Override
    public int getRequiredCharge() {
        if (this.activeRecipe == null) {
            return 0;
        }
        return this.activeRecipe.getEnergyCost();
    }

    @Override
    public int getCraftingStage() {
        return this.craftingStage.value;
    }

    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        this.updateBlock();
    }

    @Override
    public ItemStack getStackInCore(int slot) {
        return this.func_70301_a(slot);
    }

    @Override
    public void setStackInCore(int slot, ItemStack stack) {
        this.func_70299_a(slot, stack);
    }

    @Override
    public List<ICraftingPedestal> getPedestals() {
        return this.pedestals;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void initializeEffects() {
        LogHelper.dev("FusionCrafting: Initialize Effects");
        this.pedestals.clear();
        int range = 16;
        ArrayList positions = new ArrayList();
        positions.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-range, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(range, 1, 1))));
        positions.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-1, -range, -1), (BlockPos)this.field_174879_c.func_177982_a(1, range, 1))));
        positions.addAll(Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -range), (BlockPos)this.field_174879_c.func_177982_a(1, 1, range))));
        for (BlockPos checkPos : positions) {
            TileEntity tile = this.field_145850_b.func_175625_s(checkPos);
            if (!(tile instanceof ICraftingPedestal)) continue;
            ICraftingPedestal pedestal = (ICraftingPedestal)tile;
            Vec3D dirVec = new Vec3D(tile.func_174877_v()).subtract(this.field_174879_c);
            double dist = Utils.getDistanceAtoB((Vec3D)new Vec3D(tile.func_174877_v()), (Vec3D)new Vec3D(this.field_174879_c));
            if (!(dist >= 2.0) || EnumFacing.func_176737_a((float)((int)dirVec.x), (float)((int)dirVec.y), (float)((int)dirVec.z)) != pedestal.getDirection().func_176734_d() || !pedestal.setCraftingInventory(this)) continue;
            BlockPos pPos = tile.func_174877_v();
            EnumFacing facing = pedestal.getDirection();
            ArrayList checkList = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)pPos.func_177972_a(facing), (BlockPos)pPos.func_177967_a(facing, FacingUtils.destanceInDirection((BlockPos)pPos, (BlockPos)this.field_174879_c, (EnumFacing)facing) - 1)));
            boolean obstructed = false;
            for (BlockPos bp : checkList) {
                if (this.field_145850_b.func_175623_d(bp) || !this.field_145850_b.func_180495_p(bp).func_185917_h() && !(this.field_145850_b.func_175625_s(bp) instanceof ICraftingPedestal)) continue;
                obstructed = true;
                break;
            }
            if (!obstructed) {
                this.pedestals.add(pedestal);
                continue;
            }
            pedestal.setCraftingInventory(null);
        }
        this.activeRecipe = RecipeManager.FUSION_REGISTRY.findRecipe(this, this.field_145850_b, this.field_174879_c);
        if (this.activeRecipe == null) {
            this.effects = null;
            return;
        }
        this.effects = new LinkedList();
        for (ICraftingPedestal pedestal : this.pedestals) {
            if (pedestal.getStackInPedestal() == null) continue;
            pedestal.setCraftingInventory(this);
            Vec3D spawn = new Vec3D(((TileEntity)pedestal).func_174877_v());
            spawn.add(0.5 + (double)pedestal.getDirection().func_82601_c() * 0.45, 0.5 + (double)pedestal.getDirection().func_96559_d() * 0.45, 0.5 + (double)pedestal.getDirection().func_82599_e() * 0.45);
            this.effects.add(new EffectTrackerFusionCrafting(this.field_145850_b, spawn, new Vec3D(this.field_174879_c), this, this.activeRecipe.getRecipeIngredients().size()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateEffects() {
        if (this.effects == null) {
            if (this.isCrafting.value) {
                this.initializeEffects();
                this.effectRotation = 0.0;
                this.allLocked = false;
            }
            return;
        }
        double distFromCore = 1.2;
        if (this.getCraftingStage() > 1600) {
            distFromCore *= 1.0 - (double)(this.getCraftingStage() - 1600) / 400.0;
        }
        if (this.allLocked) {
            this.effectRotation -= Math.min(((double)this.getCraftingStage() - 1100.0) / 900.0 * 0.8, 0.5);
            if (this.effectRotation > 0.0) {
                this.effectRotation = 0.0;
            }
        }
        int index = 0;
        int count = this.effects.size();
        boolean flag = true;
        boolean isMoving = this.getCraftingStage() > 1000;
        for (EffectTrackerFusionCrafting effect : this.effects) {
            effect.onUpdate(isMoving);
            if (!effect.positionLocked) {
                flag = false;
            }
            if (isMoving) {
                effect.scale = 0.7f + (float)(distFromCore / 1.2) * 0.3f;
                effect.green = effect.blue = (float)(distFromCore - 0.2);
                effect.red = 1.0f - (float)(distFromCore - 0.2);
            }
            double indexPos = (double)index / (double)count;
            double offset = indexPos * (Math.PI * 2);
            double offsetX = Math.sin(this.effectRotation + offset) * distFromCore;
            double offsetZ = Math.cos(this.effectRotation + offset) * distFromCore;
            double mix = this.effectRotation / 5.0;
            double xAdditive = offsetX * Math.sin(-mix);
            double zAdditive = offsetZ * Math.cos(-mix);
            double offsetY = (xAdditive + zAdditive) * 0.2 * (distFromCore / 1.2);
            effect.circlePosition.set((double)this.field_174879_c.func_177958_n() + 0.5 + offsetX, (double)this.field_174879_c.func_177956_o() + 0.5 + offsetY, (double)this.field_174879_c.func_177952_p() + 0.5 + offsetZ);
            ++index;
        }
        SoundHandler soundManager = FMLClientHandler.instance().getClient().func_147118_V();
        if (!this.allLocked && flag) {
            soundManager.func_147682_a((ISound)new FusionRotationSound(this));
        }
        this.allLocked = flag;
        if (!this.isCrafting.value) {
            LogHelper.dev("FusionCrafting: End Effects");
            for (int i = 0; i < 100; ++i) {
                BCEffectHandler.spawnFXDirect((ResourceLocation)DEParticles.DE_SHEET, (BCParticle)new EffectTrackerFusionCrafting.SubParticle(this.field_145850_b, new Vec3D(this.field_174879_c).add(0.5, 0.5, 0.5)));
            }
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, DESoundHandler.fusionComplete, SoundCategory.BLOCKS, 2.0f, 1.0f, false);
            this.effects = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderEffects(float partialTicks) {
        if (this.effects != null) {
            ResourceHelperDE.bindTexture("textures/blocks/fusion_crafting/fusion_particle.png");
            Tessellator tessellator = Tessellator.func_178181_a();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            for (EffectTrackerFusionCrafting effect : this.effects) {
                effect.renderEffect(tessellator, partialTicks);
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-16, -16, -16), this.field_174879_c.func_177982_a(17, 17, 17));
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public int getComparatorOutput() {
        this.updatePedestals();
        if (this.getStackInCore(1) != null) {
            return 15;
        }
        if (this.craftingStage.value > 0) {
            return (int)Math.max(1.0, (double)this.craftingStage.value / 2000.0 * 15.0);
        }
        if (RecipeManager.FUSION_REGISTRY.findRecipe(this, this.field_145850_b, this.field_174879_c) != null) {
            return 1;
        }
        LogHelper.dev(this.getStackInCore(0) + " " + RecipeManager.FUSION_REGISTRY.findRecipe(this, this.field_145850_b, this.field_174879_c));
        return 0;
    }

    protected <T> T getItemHandler(Capability<T> capability, EnumFacing facing) {
        if (facing == null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandlers[facing.func_176745_a()]);
    }
}

