/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki;

import com.brandon3055.draconicevolution.client.gui.modwiki.WikiConfig;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StylePreset {
    public static final List<StylePreset> PRESETS = new LinkedList<StylePreset>();
    private final int NAV_WINDOW;
    private final int CONTENT_WINDOW;
    private final int MENU_BAR;
    private final int NAV_TEXT;
    private final int TEXT_2;
    private final String name;

    public StylePreset(String name, int nav_window, int content_window, int menu_bar, int nav_text, int text_2) {
        this.NAV_WINDOW = nav_window;
        this.CONTENT_WINDOW = content_window;
        this.MENU_BAR = menu_bar;
        this.NAV_TEXT = nav_text;
        this.TEXT_2 = text_2;
        this.name = name;
    }

    public static void addPreset(StylePreset preset) {
        PRESETS.add(preset);
    }

    public void apply() {
        WikiConfig.NAV_WINDOW = this.NAV_WINDOW;
        WikiConfig.CONTENT_WINDOW = this.CONTENT_WINDOW;
        WikiConfig.MENU_BAR = this.MENU_BAR;
        WikiConfig.NAV_TEXT = this.NAV_TEXT;
        WikiConfig.TEXT_COLOUR = this.TEXT_2;
        WikiConfig.save();
    }

    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)("modwiki.style.preset." + this.name), (Object[])new Object[0]);
    }

    static {
        StylePreset.addPreset(new StylePreset("intellij", -12828863, -12828863, -12828863, 0xD0D0D0, 0xC0C0C0));
        StylePreset.addPreset(new StylePreset("black&white", -16250872, -16250872, -16250872, 0xFFFFFF, 0xFFFFFF));
        StylePreset.addPreset(new StylePreset("white&black", -4144960, -4144960, -4144960, 0, 0));
        StylePreset.addPreset(new StylePreset("purple", -14024595, -14024595, -14024595, 0xFFFFFF, 0xFFFFFF));
        StylePreset.addPreset(new StylePreset("draconic", -8905984, -8905984, -8905984, 3735731, 3735731));
        StylePreset.addPreset(new StylePreset("transparent", -2139612416, -2139612416, -2139612416, 0xFFFFFF, 0xFFFFFF));
    }
}

