/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.model.tool;

import codechicken.lib.render.CCModelState;
import com.google.common.collect.ImmutableMap;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraftforge.common.model.TRSRTransformation;

public class ToolTransformOverride {
    private final String key;
    public static final CCModelState STAFF_STATE;
    public static final CCModelState DR_SWORD_STATE;
    public static final CCModelState WY_SWORD_STATE;
    private static final TRSRTransformation flipX;

    public ToolTransformOverride(String key) {
        this.key = key;
    }

    public CCModelState getOverride(ItemCameraTransforms.TransformType cameraTransformType, CCModelState state) {
        if (this.key.equals("draconic_staff_of_power")) {
            return cameraTransformType == ItemCameraTransforms.TransformType.FIXED || cameraTransformType == ItemCameraTransforms.TransformType.GROUND ? STAFF_STATE : state;
        }
        if (this.key.equals("draconic_sword")) {
            return cameraTransformType == ItemCameraTransforms.TransformType.FIXED || cameraTransformType == ItemCameraTransforms.TransformType.GROUND ? DR_SWORD_STATE : state;
        }
        if (this.key.equals("wyvern_sword")) {
            return cameraTransformType == ItemCameraTransforms.TransformType.FIXED || cameraTransformType == ItemCameraTransforms.TransformType.GROUND ? WY_SWORD_STATE : state;
        }
        return state;
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float rx, float ry, float rz, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(rx, ry, rz)), new Vector3f(s, s, s), null));
    }

    private static TRSRTransformation leftify(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
    }

    static {
        flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
        TRSRTransformation thirdPerson = ToolTransformOverride.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        TRSRTransformation firstPerson = ToolTransformOverride.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        ImmutableMap.Builder defaultItemBuilder = ImmutableMap.builder();
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ToolTransformOverride.get(1.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.3f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ToolTransformOverride.get(2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.55f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)ToolTransformOverride.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdPerson);
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ToolTransformOverride.leftify(thirdPerson));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstPerson);
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ToolTransformOverride.leftify(firstPerson));
        STAFF_STATE = new CCModelState(defaultItemBuilder.build());
        thirdPerson = ToolTransformOverride.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        firstPerson = ToolTransformOverride.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        defaultItemBuilder = ImmutableMap.builder();
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ToolTransformOverride.get(-2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ToolTransformOverride.get(-3.0f, -3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.65f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)ToolTransformOverride.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdPerson);
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ToolTransformOverride.leftify(thirdPerson));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstPerson);
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ToolTransformOverride.leftify(firstPerson));
        DR_SWORD_STATE = new CCModelState(defaultItemBuilder.build());
        thirdPerson = ToolTransformOverride.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        firstPerson = ToolTransformOverride.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        defaultItemBuilder = ImmutableMap.builder();
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ToolTransformOverride.get(-2.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ToolTransformOverride.get(-2.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.8f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)ToolTransformOverride.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdPerson);
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ToolTransformOverride.leftify(thirdPerson));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstPerson);
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ToolTransformOverride.leftify(firstPerson));
        WY_SWORD_STATE = new CCModelState(defaultItemBuilder.build());
    }
}

