/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseHover;
import net.minecraft.entity.boss.dragon.phase.PhaseLanding;
import net.minecraft.entity.boss.dragon.phase.PhaseLandingApproach;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.boss.dragon.phase.PhaseSittingBase;
import net.minecraft.entity.boss.dragon.phase.PhaseTakeoff;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeEndDecorator;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.feature.WorldGenEndPodium;
import net.minecraft.world.gen.feature.WorldGenSpikes;

public class EntityEnderEnergyManipulator
extends EntityLivingBase {
    private int soulsCollected = 0;
    private int stageTime = 0;
    public EntityDragon dragon = null;
    private DragonFightManager fightManager = null;
    private LinkedList<BlockPos> deadCrystals = new LinkedList();
    public static final DataParameter<Integer> STAGE = EntityDataManager.func_187226_a(EntityEnderEnergyManipulator.class, (DataSerializer)DataSerializers.field_187192_b);
    private BlockPos exitPortalLocation = null;

    public EntityEnderEnergyManipulator(World worldIn) {
        super(worldIn);
        this.func_184224_h(true);
        this.field_70145_X = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STAGE, (Object)0);
    }

    public Stage getStage() {
        return Stage.getStageByID((Integer)this.field_70180_af.func_187225_a(STAGE));
    }

    public void setStage(Stage stage) {
        this.field_70180_af.func_187227_b(STAGE, (Object)stage.getStageID());
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        BlockPos podiumPos = WorldGenEndPodium.field_186139_a;
        double x = (double)podiumPos.func_177958_n() + 0.5;
        double z = (double)podiumPos.func_177952_p() + 0.5;
        if (this.exitPortalLocation == null) {
            this.exitPortalLocation = new BlockPos(podiumPos.func_177958_n(), 100, podiumPos.func_177952_p());
            while (this.field_70170_p.func_180495_p(this.exitPortalLocation).func_177230_c() != Blocks.field_150357_h && this.exitPortalLocation.func_177956_o() > 30) {
                this.exitPortalLocation = this.exitPortalLocation.func_177977_b();
            }
            if (this.exitPortalLocation.func_177956_o() <= 30) {
                this.cancel();
                return;
            }
            LogHelper.dev(this.exitPortalLocation);
            this.exitPortalLocation = this.exitPortalLocation.func_177981_b(1);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.updateStage();
        }
        if (this.getStage() == Stage.POSITION) {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            this.func_70107_b(x, (double)this.exitPortalLocation.func_177956_o() + 0.5, z);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        if (!this.field_70170_p.field_72995_K && this.dragon != null) {
            IPhase phase;
            this.dragon.func_70624_b(null);
            if (!this.dragon.func_70089_S()) {
                this.dragon = null;
                LogHelper.dev("Re-Acquire Dragon");
                List list = this.field_70170_p.func_175644_a(EntityDragon.class, EntitySelectors.field_94557_a);
                for (EntityDragon listItem : list) {
                    if (this.dragon != null && !(listItem.func_70011_f(x, (double)this.exitPortalLocation.func_177956_o() + 0.5, z) < this.dragon.func_70011_f(x, (double)this.exitPortalLocation.func_177956_o() + 0.5, z))) continue;
                    this.dragon = listItem;
                }
                if (this.dragon == null) {
                    this.cancel();
                    return;
                }
            }
            if (this.getStage() != Stage.EXTRACT) {
                phase = this.dragon.func_184670_cT().func_188756_a();
                if (phase instanceof PhaseLandingApproach || phase instanceof PhaseLanding || phase instanceof PhaseSittingBase) {
                    this.dragon.func_184670_cT().func_188758_a(PhaseList.field_188741_a);
                }
            } else if (this.stageTime < 300) {
                phase = this.dragon.func_184670_cT().func_188756_a();
                if (phase instanceof PhaseTakeoff) {
                    this.dragon.func_184670_cT().func_188758_a(PhaseList.field_188747_g);
                } else if (!(phase instanceof PhaseLandingApproach || phase instanceof PhaseLanding || phase instanceof PhaseSittingBase || phase instanceof PhaseHover)) {
                    this.dragon.func_184670_cT().func_188758_a(PhaseList.field_188744_d);
                }
            }
        }
    }

    public void func_70030_z() {
    }

    private void updateStage() {
        BlockPos podiumPos = WorldGenEndPodium.field_186139_a;
        double x = (double)podiumPos.func_177958_n() + 0.5;
        double z = (double)podiumPos.func_177952_p() + 0.5;
        switch (this.getStage()) {
            case POSITION: {
                if (this.func_70011_f(x, (double)this.exitPortalLocation.func_177956_o() + 0.5, z) > 0.1) {
                    ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.END_ROD, true, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1, 0.0, 0.0, 0.0, 0.01, new int[]{0});
                    double speed = 0.1;
                    Vec3D dirVec = Vec3D.getDirectionVec((Vec3D)new Vec3D((Entity)this), (Vec3D)new Vec3D(x, (double)this.exitPortalLocation.func_177956_o() + 0.5, z));
                    this.field_70159_w = dirVec.x * speed;
                    this.field_70181_x = dirVec.y * speed;
                    this.field_70179_y = dirVec.z * speed;
                    ++this.stageTime;
                    break;
                }
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.func_70107_b(x, (double)this.exitPortalLocation.func_177956_o() + 0.5, z);
                this.setStage(Stage.ACQUIRE_DRAGON);
                this.stageTime = 0;
                break;
            }
            case ACQUIRE_DRAGON: {
                if (this.stageTime == 0) {
                    if (!(this.field_70170_p.field_73011_w instanceof WorldProviderEnd)) {
                        this.cancel();
                        return;
                    }
                    this.fightManager = ((WorldProviderEnd)this.field_70170_p.field_73011_w).func_186063_s();
                    List list = this.field_70170_p.func_175644_a(EntityDragon.class, EntitySelectors.field_94557_a);
                    if (this.fightManager.field_186117_k || list.isEmpty()) {
                        this.cancel();
                        return;
                    }
                    for (EntityDragon listItem : list) {
                        if (this.dragon != null && !(listItem.func_70011_f(x - 0.5, (double)this.exitPortalLocation.func_177956_o() + 0.5, z - 0.5) < this.dragon.func_70011_f(x - 0.5, (double)this.exitPortalLocation.func_177956_o() + 0.5, z - 0.5))) continue;
                        this.dragon = listItem;
                    }
                    for (WorldGenSpikes.EndSpike genSpike : BiomeEndDecorator.func_185426_a((World)this.field_70170_p)) {
                        boolean crystalFound = false;
                        for (EntityEnderCrystal entityendercrystal : this.field_70170_p.func_72872_a(EntityEnderCrystal.class, genSpike.func_186153_f())) {
                            entityendercrystal.func_184516_a(this.exitPortalLocation.func_177979_c(2));
                            entityendercrystal.func_184224_h(true);
                            crystalFound = true;
                        }
                        if (crystalFound) continue;
                        this.deadCrystals.add(new BlockPos((double)genSpike.func_186151_a() + 0.5, (double)(genSpike.func_186149_d() + 1), (double)genSpike.func_186152_b() + 0.5));
                    }
                } else if (this.deadCrystals.size() > 0 && this.stageTime > 50) {
                    BlockPos pos = this.deadCrystals.remove(this.field_70146_Z.nextInt(this.deadCrystals.size()));
                    this.field_70170_p.func_72876_a((Entity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 5.0f, true);
                    EntityEnderCrystal crystal = new EntityEnderCrystal(this.field_70170_p);
                    crystal.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)crystal);
                    crystal.func_184224_h(true);
                    crystal.func_184516_a(this.exitPortalLocation.func_177979_c(2));
                    this.stageTime = 0;
                }
                if (this.stageTime > 50) {
                    this.setStage(Stage.COLLECT_SOULS);
                    this.stageTime = 0;
                    return;
                }
                ++this.stageTime;
                break;
            }
            case COLLECT_SOULS: {
                if (this.stageTime % 20 == 0) {
                    List list = this.field_70170_p.func_175647_a(EntityEnderman.class, this.func_174813_aQ().func_72314_b(300.0, 300.0, 300.0), EntitySelectors.field_94557_a);
                    if (list.size() < 20) {
                        this.spawnNewEnderman();
                    }
                    int targeting = 0;
                    for (EntityEnderman enderman : list) {
                        if (enderman.func_70011_f(0.0, 64.0, 0.0) > 60.0) {
                            enderman.func_70106_y();
                            continue;
                        }
                        if (++targeting > 5 && enderman.func_70638_az() == this && this.field_70146_Z.nextInt(20) == 0) {
                            EntityPlayer player = Utils.getClosestPlayer((World)this.field_70170_p, (double)enderman.field_70165_t, (double)enderman.field_70163_u, (double)enderman.field_70161_v, (double)50.0, (boolean)false);
                            if (player != null) {
                                enderman.func_70624_b((EntityLivingBase)player);
                                continue;
                            }
                            enderman.func_70624_b((EntityLivingBase)this);
                            continue;
                        }
                        if (targeting > 5 && enderman.func_70638_az() instanceof EntityPlayer) continue;
                        enderman.func_70624_b((EntityLivingBase)this);
                    }
                    for (int i = this.field_70146_Z.nextInt(4); i >= 0; --i) {
                        this.killnextEnderman();
                    }
                }
                if (this.soulsCollected > 100) {
                    this.stageTime = 0;
                    this.setStage(Stage.EXTRACT);
                }
                ++this.stageTime;
                break;
            }
            case EXTRACT: {
                double dragonDist;
                if (this.stageTime % 20 == 0) {
                    List list = this.field_70170_p.func_175647_a(EntityEnderman.class, this.func_174813_aQ().func_72314_b(300.0, 300.0, 300.0), EntitySelectors.field_94557_a);
                    for (EntityEnderman enderman : list) {
                        enderman.func_70624_b((EntityLivingBase)this);
                    }
                }
                double d = dragonDist = this.dragon == null ? 100.0 : this.dragon.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.dragon != null && dragonDist < 10.0) {
                    BCEffectHandler.spawnFX((int)DEParticles.SOUL_EXTRACTION, (World)this.field_70170_p, (Vec3D)new Vec3D((Entity)this.dragon).add(0.0, 2.0, 0.0), (Vec3D)new Vec3D((Entity)this), (double)512.0, (int[])new int[]{3});
                }
                if (this.stageTime == 300) {
                    List list = this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ().func_72314_b(300.0, 300.0, 300.0), EntitySelectors.field_94557_a);
                    for (Entity entity : list) {
                        if (!(entity instanceof EntityEnderman) && (!(entity instanceof EntityItem) || ((EntityItem)entity).func_92059_d().func_77973_b() != Items.field_151079_bi) && !(entity instanceof EntityAreaEffectCloud)) continue;
                        entity.func_70106_y();
                    }
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 40.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    PacketCustom.sendToAllAround((Packet)new SPacketExplosion(this.field_70165_t, this.field_70163_u, this.field_70161_v, 505.0f, Collections.emptyList(), new Vec3d(0.0, 0.0, 0.0)), (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)512.0, (int)1);
                    EntityPersistentItem entityItem = new EntityPersistentItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Blocks.field_150380_bt));
                    this.field_70170_p.func_72838_d((Entity)entityItem);
                    entityItem.field_70179_y = 0.0;
                    entityItem.field_70181_x = 0.0;
                    entityItem.field_70159_w = 0.0;
                    this.cleanup();
                    if (this.dragon != null) {
                        this.dragon.func_184670_cT().func_188758_a(PhaseList.field_188749_i);
                    }
                }
                if (this.stageTime > 320) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187533_aW, SoundCategory.MASTER, 10.0f, 0.7f);
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187533_aW, SoundCategory.MASTER, 10.0f, 1.0f);
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187533_aW, SoundCategory.MASTER, 10.0f, 1.3f);
                    this.func_70106_y();
                }
                if (this.dragon == null || !(dragonDist < 10.0) && this.stageTime < 300) break;
                ++this.stageTime;
                break;
            }
        }
    }

    private void cancel() {
        if (!this.field_70170_p.field_72995_K) {
            this.cleanup();
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack((Item)DEFeatures.enderEnergyManipulator)));
            this.func_70106_y();
        }
    }

    private void cleanup() {
        for (WorldGenSpikes.EndSpike worldgenspikes$endspike : BiomeEndDecorator.func_185426_a((World)this.field_70170_p)) {
            for (EntityEnderCrystal entityendercrystal : this.field_70170_p.func_72872_a(EntityEnderCrystal.class, worldgenspikes$endspike.func_186153_f())) {
                entityendercrystal.func_184516_a(null);
                entityendercrystal.func_184224_h(false);
            }
        }
    }

    private void spawnNewEnderman() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            BlockPos spawnPos = this.field_70170_p.func_175672_r(new BlockPos(this.field_70165_t + (double)this.field_70146_Z.nextInt(50) - 25.0, 255.0, this.field_70161_v + (double)this.field_70146_Z.nextInt(50) - 25.0));
            if (this.field_70170_p.func_175623_d(spawnPos)) continue;
            EntityEnderman enderman = new EntityEnderman(this.field_70170_p);
            enderman.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)(spawnPos.func_177956_o() + 1), (double)spawnPos.func_177952_p() + 0.5);
            this.field_70170_p.func_72838_d((Entity)enderman);
        }
    }

    private void killnextEnderman() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        List list = this.field_70170_p.func_175647_a(EntityEnderman.class, this.func_174813_aQ().func_72314_b(8.0, 15.0, 8.0), EntitySelectors.field_94557_a);
        if (!list.isEmpty()) {
            EntityEnderman enderman = (EntityEnderman)list.get(this.field_70146_Z.nextInt(list.size()));
            enderman.captureDrops = true;
            Vec3D dirVec = Vec3D.getDirectionVec((Vec3D)new Vec3D((Entity)enderman), (Vec3D)new Vec3D(this.field_70165_t, (double)this.exitPortalLocation.func_177956_o() + 0.5, this.field_70161_v));
            enderman.field_70159_w = dirVec.x;
            enderman.field_70181_x = dirVec.y;
            enderman.field_70179_y = dirVec.z;
            enderman.func_70097_a(DamageSource.field_76376_m, 10000.0f);
            ++this.soulsCollected;
            BCEffectHandler.spawnFX((int)DEParticles.SOUL_EXTRACTION, (World)this.field_70170_p, (Vec3D)new Vec3D((Entity)enderman), (Vec3D)new Vec3D((Entity)this), (int[])new int[]{100});
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.soulsCollected = compound.func_74762_e("SoulsCollected");
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("SoulsCollected", this.soulsCollected);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    @Nullable
    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return null;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, @Nullable ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    protected boolean func_70610_aX() {
        return true;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    private static enum Stage {
        POSITION(0),
        ACQUIRE_DRAGON(1),
        COLLECT_SOULS(2),
        EXTRACT(3);

        public final int stageID;

        private Stage(int stageID) {
            this.stageID = stageID;
        }

        public int getStageID() {
            return this.stageID;
        }

        public static Stage getStageByID(int stageID) {
            if (stageID < 0 || stageID >= Stage.values().length) {
                return POSITION;
            }
            return Stage.values()[stageID];
        }
    }
}

