/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.lib.ShortPos;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.network.PacketExplosionFX;
import com.brandon3055.draconicevolution.utils.LogHelper;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ExplosionHelper {
    private final WorldServer serverWorld;
    private BlockPos start;
    private ShortPos shortPos;
    private THashSet<Chunk> modifiedChunks = new THashSet();
    private HashSet<Integer> blocksToUpdate = new HashSet();
    private HashSet<Integer> tilesToRemove = new HashSet();
    private HashMap<ChunkPos, Chunk> chunkCache = new HashMap();
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    public LinkedList<HashSet<Integer>> toRemove = new LinkedList();

    public ExplosionHelper(WorldServer serverWorld, BlockPos start, ShortPos shortPos) {
        this.serverWorld = serverWorld;
        this.start = start;
        this.shortPos = shortPos;
    }

    public void setBlocksForRemoval(LinkedList<HashSet<Integer>> list) {
        this.toRemove = list;
    }

    public void addBlocksForUpdate(Collection<Integer> blocksToUpdate) {
        this.blocksToUpdate.addAll(blocksToUpdate);
    }

    private void removeBlock(BlockPos pos) {
        ExtendedBlockStorage storage;
        Chunk chunk = this.getChunk(pos);
        IBlockState oldState = chunk.func_177435_g(pos);
        if (oldState.func_177230_c().hasTileEntity(oldState)) {
            PlayerChunkMapEntry watcher;
            this.serverWorld.func_175698_g(pos);
            PlayerChunkMap playerChunkMap = this.serverWorld.func_184164_w();
            if (playerChunkMap != null && (watcher = playerChunkMap.func_187301_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) != null) {
                watcher.func_187267_a((Packet)new SPacketBlockChange((World)this.serverWorld, pos));
            }
        }
        if ((storage = this.getBlockStorage(pos)) != null) {
            storage.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, AIR);
        }
        this.setChunkModified(pos);
    }

    public void setChunkModified(BlockPos blockPos) {
        Chunk chunk = this.getChunk(blockPos);
        this.setChunkModified(chunk);
    }

    public void setChunkModified(Chunk chunk) {
        this.modifiedChunks.add((Object)chunk);
    }

    private Chunk getChunk(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        if (!this.chunkCache.containsKey(cp)) {
            this.chunkCache.put(cp, this.serverWorld.func_72964_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4));
        }
        return this.chunkCache.get(cp);
    }

    private boolean hasBlockStorage(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        return chunk.field_76652_q[pos.func_177956_o() >> 4] != null;
    }

    private ExtendedBlockStorage getBlockStorage(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        return chunk.field_76652_q[pos.func_177956_o() >> 4];
    }

    private void setRecalcPrecipitationHeightMap(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        int i = (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF;
        if (pos.func_177956_o() >= chunk.field_76638_b[i] - 1) {
            chunk.field_76638_b[i] = -999;
        }
    }

    private void fireBlockBreak(BlockPos pos, IBlockState oldState) {
        oldState.func_177230_c().func_180663_b((World)this.serverWorld, pos, oldState);
    }

    private void removeTileEntity(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        TileEntity tileEntity = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        if (tileEntity != null) {
            this.serverWorld.func_175713_t(pos);
        }
    }

    public void finish() {
        LogHelper.dev("EH: finish");
        RemovalProcess process = new RemovalProcess(this);
        ProcessHandler.addProcess((IProcess)process);
    }

    public boolean isAirBlock(BlockPos pos) {
        return this.serverWorld.func_175623_d(pos);
    }

    public IBlockState getBlockState(BlockPos pos) {
        ExtendedBlockStorage storage = this.getBlockStorage(pos);
        if (storage == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return storage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
    }

    private static class RemovalProcess
    implements IProcess {
        public boolean isDead = false;
        private ExplosionHelper helper;
        int index = 0;
        private MinecraftServer server;

        public RemovalProcess(ExplosionHelper helper) {
            this.helper = helper;
            this.server = helper.serverWorld.func_73046_m();
        }

        public void updateProcess() {
            this.server.field_175591_ab = MinecraftServer.func_130071_aq();
            while (MinecraftServer.func_130071_aq() - this.server.field_175591_ab < 50L && this.helper.toRemove.size() > 0) {
                LogHelper.dev("Processing chunks ar rad: " + this.index);
                HashSet<Integer> set = this.helper.toRemove.removeFirst();
                for (int pos : set) {
                    this.helper.removeBlock(this.helper.shortPos.getActualPos(pos));
                }
                ++this.index;
            }
            this.finishChunks();
            if (this.helper.toRemove.isEmpty()) {
                this.isDead = true;
                this.updateBlocks();
            }
        }

        public void finishChunks() {
            PlayerChunkMap playerChunkMap = this.helper.serverWorld.func_184164_w();
            if (playerChunkMap == null) {
                return;
            }
            for (Chunk chunk : this.helper.modifiedChunks) {
                chunk.func_177427_f(true);
                chunk.func_76603_b();
                PlayerChunkMapEntry watcher = playerChunkMap.func_187301_b(chunk.field_76635_g, chunk.field_76647_h);
                if (watcher == null) continue;
                watcher.func_187267_a((Packet)new SPacketChunkData(chunk, 65535));
            }
            this.helper.modifiedChunks.clear();
        }

        private void updateBlocks() {
            LogHelper.startTimer("Updating Blocks");
            try {
                LogHelper.dev("Updating " + this.helper.blocksToUpdate.size() + " Blocks");
                BlockFalling.field_149832_M = true;
                Iterator iterator = this.helper.blocksToUpdate.iterator();
                while (iterator.hasNext()) {
                    int pos = (Integer)iterator.next();
                    IBlockState state = this.helper.serverWorld.func_180495_p(this.helper.shortPos.getActualPos(pos));
                    if (state.func_177230_c() instanceof BlockFalling) {
                        state.func_177230_c().func_180650_b((World)this.helper.serverWorld, this.helper.shortPos.getActualPos(pos), state, ((ExplosionHelper)this.helper).serverWorld.field_73012_v);
                    }
                    state.func_189546_a((World)this.helper.serverWorld, this.helper.shortPos.getActualPos(pos), Blocks.field_150350_a);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            LogHelper.stopTimer();
            BlockFalling.field_149832_M = false;
            PacketExplosionFX packet = new PacketExplosionFX(this.helper.start, 0, true);
            DraconicEvolution.network.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(((ExplosionHelper)this.helper).serverWorld.field_73011_w.getDimension(), (double)this.helper.start.func_177958_n(), (double)this.helper.start.func_177956_o(), (double)this.helper.start.func_177952_p(), 500.0));
        }

        public boolean isDead() {
            return this.isDead;
        }
    }
}

