/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TreeHarvester {
    private BlockPos pos;
    private EntityPlayer player;
    private World world;
    private Item[] tools;
    private Block[] logTypes;
    private Block[] groundTypes;
    private ItemStack heldItem;
    private IBlockState meta;

    public TreeHarvester(BlockPos pos, EntityPlayer player, World world, Item[] tools, Block[] logTypes, Block[] groundTypes) {
        this.pos = pos;
        this.player = player;
        this.world = world;
        this.tools = tools;
        this.heldItem = player.func_184614_ca();
        this.logTypes = logTypes;
        this.groundTypes = groundTypes;
    }

    public void harvest() {
        if (this.heldItem == null) {
            return;
        }
        Item item = this.heldItem.func_77973_b();
        if (item == null) {
            return;
        }
        if (this.player.func_70093_af()) {
            return;
        }
        if (!this.contains(this.tools, item)) {
            return;
        }
        this.meta = this.getMeta(this.pos);
        if (!this.isLog(this.pos)) {
            return;
        }
        if (!this.isGround(this.pos.func_177977_b())) {
            return;
        }
        if (!((Comparable)this.world.func_180495_p(this.pos).func_177228_b().get((Object)BlockLog.field_176299_a)).equals(BlockLog.EnumAxis.Y)) {
            return;
        }
        this.destroyTree();
    }

    private void destroyTree() {
        this.destroyConnectedLogs(this.pos, new Counter(128));
    }

    private void destroyConnectedLogs(BlockPos pos, Counter counter) {
        if (counter.isZero()) {
            return;
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.check(positions, pos, x, y, z);
                }
            }
        }
        for (BlockPos p : positions) {
            if (counter.isZero()) {
                return;
            }
            this.destroy(p);
            counter.decrement();
            this.destroyConnectedLogs(p, counter);
        }
    }

    private void check(ArrayList<BlockPos> positions, BlockPos pos, int x, int y, int z) {
        if (this.isLog(pos.func_177982_a(x, y, z))) {
            positions.add(pos.func_177982_a(x, y, z));
        }
    }

    public IBlockState getMeta(BlockPos pos) {
        try {
            return this.world.func_180495_p(pos).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        }
        catch (Exception e) {
            return this.world.func_180495_p(pos);
        }
    }

    private boolean isLog(BlockPos pos) {
        Block b = this.world.func_180495_p(pos).func_177230_c();
        if (this.contains(this.logTypes, b)) {
            return this.getMeta(pos) == this.meta;
        }
        return false;
    }

    private boolean isGround(BlockPos pos) {
        Block b = this.world.func_180495_p(pos).func_177230_c();
        return this.contains(this.groundTypes, b);
    }

    private void destroy(BlockPos pos) {
        if (this.heldItem != null) {
            this.heldItem.func_77973_b().func_179218_a(this.heldItem, this.world, this.world.func_180495_p(pos), pos, (EntityLivingBase)this.player);
            this.world.func_175655_b(pos, true);
        }
    }

    private boolean contains(Object[] array, Object contains) {
        for (Object o : array) {
            if (!contains.equals(o)) continue;
            return true;
        }
        return false;
    }

    private class Counter {
        private int i;

        public Counter(int i) {
            this.i = i;
        }

        public int getNumber() {
            return this.i;
        }

        public boolean isZero() {
            return this.i <= 0;
        }

        public void setNumber(int i) {
            this.i = i;
        }

        public Counter decrement() {
            if (this.i <= 0) {
                return this;
            }
            --this.i;
            return this;
        }
    }
}

