/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.api.pack;

import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;

public enum BlockConfiguration {
    BasicFull1(BlockType.Drawers, EnumBasicDrawer.FULL1),
    BasicFull2(BlockType.Drawers, EnumBasicDrawer.FULL2),
    BasicFull4(BlockType.Drawers, EnumBasicDrawer.FULL4),
    BasicHalf2(BlockType.Drawers, EnumBasicDrawer.HALF2),
    BasicHalf4(BlockType.Drawers, EnumBasicDrawer.HALF4),
    Trim(BlockType.Trim, null);

    private final BlockType type;
    private final EnumBasicDrawer drawer;

    private BlockConfiguration(BlockType type, EnumBasicDrawer drawer) {
        this.type = type;
        this.drawer = drawer;
    }

    public BlockType getBlockType() {
        return this.type;
    }

    public int getDrawerCount() {
        return this.drawer != null ? this.drawer.getDrawerCount() : 0;
    }

    public boolean isHalfDepth() {
        return this.drawer != null && this.drawer.isHalfDepth();
    }

    public static BlockConfiguration by(BlockType type, EnumBasicDrawer drawer) {
        for (BlockConfiguration config : BlockConfiguration.values()) {
            if (config.type != type || config.drawer != drawer) continue;
            return config;
        }
        return null;
    }
}

