/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.CachedBuilderModel;
import com.jaquadro.minecraft.chameleon.model.ChamModel;
import com.jaquadro.minecraft.chameleon.model.ProxyBuilderModel;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.resources.IconUtil;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.modeldata.DrawerStateModelData;
import com.jaquadro.minecraft.storagedrawers.block.modeldata.MaterialModelData;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerDecoratorModel;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerSealedModel;
import com.jaquadro.minecraft.storagedrawers.client.model.dynamic.CommonDrawerRenderer;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public class CustomDrawerModel
extends ChamModel {
    private static final int[] iconIndex = new int[]{0, 0, 1, 0, 2};
    private TextureAtlasSprite iconParticle;
    private static final ItemHandler itemHandler = new ItemHandler();

    public static IBakedModel fromBlock(IBlockState state) {
        if (!(state instanceof IExtendedBlockState)) {
            return new CustomDrawerModel(state, false);
        }
        IExtendedBlockState xstate = (IExtendedBlockState)state;
        DrawerStateModelData stateModel = (DrawerStateModelData)((Object)xstate.getValue(BlockDrawers.STATE_MODEL));
        MaterialModelData matModel = (MaterialModelData)((Object)xstate.getValue(BlockDrawersCustom.MAT_MODEL));
        if (stateModel == null || matModel == null) {
            return new CustomDrawerModel(state, false);
        }
        ItemStack effMatFront = matModel.getEffectiveMaterialFront();
        ItemStack effMatSide = matModel.getEffectiveMaterialSide();
        ItemStack effMatTrim = matModel.getEffectiveMaterialTrim();
        ItemStack matFront = matModel.getMaterialFront();
        ItemStack matSide = matModel.getMaterialSide();
        ItemStack matTrim = matModel.getMaterialTrim();
        return new CustomDrawerModel(state, effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim, false);
    }

    public static IBakedModel fromItem(ItemStack stack) {
        IBlockState state = ModBlocks.customDrawers.func_176203_a(stack.func_77960_j());
        if (!stack.func_77942_o()) {
            return new CustomDrawerModel(state, true);
        }
        NBTTagCompound tag = stack.func_77978_p();
        ItemStack matFront = null;
        ItemStack matSide = null;
        ItemStack matTrim = null;
        if (tag.func_150297_b("MatF", 10)) {
            matFront = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatF"));
        }
        if (tag.func_150297_b("MatS", 10)) {
            matSide = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatS"));
        }
        if (tag.func_150297_b("MatT", 10)) {
            matTrim = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatT"));
        }
        ItemStack effMatFront = matFront != null ? matFront : matSide;
        ItemStack effMatTrim = matTrim != null ? matTrim : matSide;
        ItemStack effMatSide = matSide;
        CustomDrawerModel model = new CustomDrawerModel(state, effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim, true);
        if (!stack.func_77978_p().func_150297_b("tile", 10)) {
            return model;
        }
        return new DrawerSealedModel((IBakedModel)model, state, true);
    }

    private CustomDrawerModel(IBlockState state, boolean mergeLayers) {
        this(state, null, null, null, null, null, null, mergeLayers);
    }

    private CustomDrawerModel(IBlockState state, ItemStack effMatFront, ItemStack effMatSide, ItemStack effMatTrim, ItemStack matFront, ItemStack matSide, ItemStack matTrim, boolean mergeLayers) {
        super(state, mergeLayers, new Object[]{effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim});
    }

    protected void renderMippedLayer(ChamRender renderer, IBlockState state, Object ... args) {
        EnumBasicDrawer info = (EnumBasicDrawer)((Object)state.func_177229_b(BlockStandardDrawers.BLOCK));
        int index = iconIndex[info.getDrawerCount()];
        TextureAtlasSprite iconFront = IconUtil.getIconFromStack((ItemStack)((ItemStack)args[0]));
        TextureAtlasSprite iconSide = IconUtil.getIconFromStack((ItemStack)((ItemStack)args[1]));
        TextureAtlasSprite iconTrim = IconUtil.getIconFromStack((ItemStack)((ItemStack)args[2]));
        if (iconFront == null) {
            iconFront = iconSide;
        }
        if (iconTrim == null) {
            iconTrim = iconSide;
        }
        if (iconFront == null) {
            iconFront = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultFront[index]);
        }
        if (iconSide == null) {
            iconSide = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        if (iconTrim == null) {
            iconTrim = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        this.iconParticle = iconSide;
        CommonDrawerRenderer drawerRenderer = new CommonDrawerRenderer(renderer);
        drawerRenderer.renderBasePass(null, state, BlockPos.field_177992_a, (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING), iconSide, iconTrim, iconFront);
    }

    protected void renderTransLayer(ChamRender renderer, IBlockState state, Object ... args) {
        EnumBasicDrawer info = (EnumBasicDrawer)((Object)state.func_177229_b(BlockStandardDrawers.BLOCK));
        int index = iconIndex[info.getDrawerCount()];
        TextureAtlasSprite iconOverlayFace = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayFace[index]);
        TextureAtlasSprite iconOverlayHandle = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayHandle[index]);
        TextureAtlasSprite iconTrim = IconUtil.getIconFromStack((ItemStack)((ItemStack)args[5]));
        TextureAtlasSprite iconOverlayTrim = iconTrim == null ? Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayBoldTrim[index]) : Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayTrim[index]);
        CommonDrawerRenderer drawerRenderer = new CommonDrawerRenderer(renderer);
        drawerRenderer.renderOverlayPass(null, state, BlockPos.field_177992_a, (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING), iconOverlayTrim, iconOverlayHandle, iconOverlayFace);
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iconParticle;
    }

    private static class ItemHandler
    extends ItemOverrideList {
        public ItemHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            return CustomDrawerModel.fromItem(stack);
        }
    }

    public static class Model
    extends ProxyBuilderModel {
        public Model() {
            super(Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide));
        }

        protected IBakedModel buildModel(IBlockState state, IBakedModel parent) {
            IBakedModel mainModel = CustomDrawerModel.fromBlock(state);
            if (!(state instanceof IExtendedBlockState)) {
                return mainModel;
            }
            IExtendedBlockState xstate = (IExtendedBlockState)state;
            DrawerStateModelData stateModel = (DrawerStateModelData)((Object)xstate.getValue(BlockDrawers.STATE_MODEL));
            try {
                if (!DrawerDecoratorModel.shouldHandleState(stateModel)) {
                    return mainModel;
                }
                EnumBasicDrawer drawer = (EnumBasicDrawer)((Object)state.func_177229_b(BlockStandardDrawers.BLOCK));
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING);
                DrawerDecoratorModel decModel = new DrawerDecoratorModel(mainModel, xstate, drawer, dir, stateModel);
                decModel.addBaseRenderLayer(BlockRenderLayer.TRANSLUCENT);
                return decModel;
            }
            catch (Throwable t) {
                try {
                    return mainModel;
                }
                catch (Throwable t2) {
                    return parent;
                }
            }
        }

        public ItemOverrideList func_188617_f() {
            return itemHandler;
        }

        public List<Object> getKey(IBlockState state) {
            try {
                ArrayList<Object> key = new ArrayList<Object>();
                IExtendedBlockState xstate = (IExtendedBlockState)state;
                key.add(xstate.getValue(BlockDrawers.STATE_MODEL));
                key.add(xstate.getValue(BlockDrawersCustom.MAT_MODEL));
                return key;
            }
            catch (Throwable t) {
                return super.getKey(state);
            }
        }
    }

    public static class Register
    extends DefaultRegister {
        public static final ResourceLocation iconDefaultSide = new ResourceLocation("StorageDrawers:blocks/drawers_raw_side");
        public static final ResourceLocation[] iconDefaultFront = new ResourceLocation[]{new ResourceLocation("StorageDrawers:blocks/drawers_raw_front_1"), new ResourceLocation("StorageDrawers:blocks/drawers_raw_front_2"), new ResourceLocation("StorageDrawers:blocks/drawers_raw_front_4")};
        public static final ResourceLocation[] iconOverlayTrim = new ResourceLocation[]{new ResourceLocation("StorageDrawers:blocks/overlay/shading_trim_1"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_trim_2"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_trim_4")};
        public static final ResourceLocation[] iconOverlayBoldTrim = new ResourceLocation[]{new ResourceLocation("StorageDrawers:blocks/overlay/shading_boldtrim_1"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_boldtrim_2"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_boldtrim_4")};
        public static final ResourceLocation[] iconOverlayFace = new ResourceLocation[]{new ResourceLocation("StorageDrawers:blocks/overlay/shading_face_1"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_face_2"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_face_4")};
        public static final ResourceLocation[] iconOverlayHandle = new ResourceLocation[]{new ResourceLocation("StorageDrawers:blocks/overlay/handle_1"), new ResourceLocation("StorageDrawers:blocks/overlay/handle_2"), new ResourceLocation("StorageDrawers:blocks/overlay/handle_4")};

        public Register() {
            super((Block)ModBlocks.customDrawers);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumBasicDrawer drawer : EnumBasicDrawer.values()) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    states.add(ModBlocks.customDrawers.func_176223_P().func_177226_a(BlockStandardDrawers.BLOCK, (Comparable)((Object)drawer)).func_177226_a((IProperty)BlockDrawers.FACING, (Comparable)dir));
                }
            }
            return states;
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model());
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model());
        }

        public List<ResourceLocation> getTextureResources() {
            ArrayList<ResourceLocation> resource = new ArrayList<ResourceLocation>();
            resource.add(iconDefaultSide);
            resource.addAll(Arrays.asList(iconDefaultFront));
            resource.addAll(Arrays.asList(iconOverlayTrim));
            resource.addAll(Arrays.asList(iconOverlayBoldTrim));
            resource.addAll(Arrays.asList(iconOverlayFace));
            resource.addAll(Arrays.asList(iconOverlayHandle));
            return resource;
        }
    }
}

