/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.ChamModel;
import com.jaquadro.minecraft.chameleon.model.ProxyBuilderModel;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.resources.IconUtil;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrimCustom;
import com.jaquadro.minecraft.storagedrawers.block.modeldata.MaterialModelData;
import com.jaquadro.minecraft.storagedrawers.client.model.dynamic.CommonTrimRenderer;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public class CustomTrimModel
extends ChamModel {
    private TextureAtlasSprite iconParticle;
    private static final ItemHandler itemHandler = new ItemHandler();

    public static CustomTrimModel fromBlock(IBlockState state) {
        IExtendedBlockState xstate;
        MaterialModelData matModel;
        if (state instanceof IExtendedBlockState && (matModel = (MaterialModelData)((Object)(xstate = (IExtendedBlockState)state).getValue(BlockTrimCustom.MAT_MODEL))) != null) {
            ItemStack matSide = matModel.getEffectiveMaterialSide();
            ItemStack matTrim = matModel.getEffectiveMaterialTrim();
            return new CustomTrimModel(state, matSide, matTrim, false);
        }
        return new CustomTrimModel(state, false);
    }

    public static CustomTrimModel fromItem(ItemStack stack) {
        IBlockState state = ModBlocks.customTrim.func_176203_a(stack.func_77960_j());
        if (!stack.func_77942_o()) {
            return new CustomTrimModel(state, true);
        }
        NBTTagCompound tag = stack.func_77978_p();
        ItemStack matSide = null;
        ItemStack matTrim = null;
        if (tag.func_150297_b("MatS", 10)) {
            matSide = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatS"));
        }
        if (tag.func_150297_b("MatT", 10)) {
            matTrim = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatT"));
        }
        return new CustomTrimModel(state, matSide, matTrim, true);
    }

    private CustomTrimModel(IBlockState state, boolean mergeLayers) {
        this(state, null, null, mergeLayers);
    }

    private CustomTrimModel(IBlockState state, ItemStack matSide, ItemStack matTrim, boolean mergeLayers) {
        super(state, mergeLayers, new Object[]{matSide, matTrim});
    }

    protected void renderMippedLayer(ChamRender renderer, IBlockState state, Object ... args) {
        TextureAtlasSprite iconSide = IconUtil.getIconFromStack((ItemStack)((ItemStack)args[0]));
        TextureAtlasSprite iconTrim = IconUtil.getIconFromStack((ItemStack)((ItemStack)args[1]));
        if (iconTrim == null) {
            iconTrim = iconSide;
        }
        if (iconSide == null) {
            iconSide = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        if (iconTrim == null) {
            iconTrim = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        this.iconParticle = iconSide;
        CommonTrimRenderer drawerRenderer = new CommonTrimRenderer(renderer);
        drawerRenderer.render(null, state, BlockPos.field_177992_a, iconSide, iconTrim);
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iconParticle;
    }

    private static class ItemHandler
    extends ItemOverrideList {
        public ItemHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            return CustomTrimModel.fromItem(stack);
        }
    }

    public static class Model
    extends ProxyBuilderModel {
        public Model() {
            super(Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide));
        }

        protected IBakedModel buildModel(IBlockState state, IBakedModel parent) {
            try {
                return CustomTrimModel.fromBlock(state);
            }
            catch (Throwable t) {
                return parent;
            }
        }

        public ItemOverrideList func_188617_f() {
            return itemHandler;
        }
    }

    public static class Register
    extends DefaultRegister {
        public static final ResourceLocation iconDefaultSide = new ResourceLocation("StorageDrawers:blocks/drawers_raw_side");

        public Register() {
            super((Block)ModBlocks.customTrim);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            states.add(ModBlocks.customTrim.func_176223_P());
            return states;
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new Model();
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new Model();
        }

        public List<ResourceLocation> getTextureResources() {
            ArrayList<ResourceLocation> resource = new ArrayList<ResourceLocation>();
            resource.add(iconDefaultSide);
            return resource;
        }
    }
}

