/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim;

import java.util.Random;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.types.EffectType;
import mcjty.rftoolsdim.dimensions.types.FeatureType;
import mcjty.rftoolsdim.items.ModItems;
import mcjty.rftoolsdim.network.DimensionSyncPacket;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.relauncher.Side;

public class ForgeEventHandlers {
    private Random random = new Random();

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Logging.log((String)"SMP: Player logged in: Sync diminfo to clients");
        EntityPlayer player = event.player;
        RfToolsDimensionManager manager = RfToolsDimensionManager.getDimensionManager(player.func_130014_f_());
        manager.syncDimInfoToClients(player.func_130014_f_());
        manager.syncDimletRules(player);
    }

    @SubscribeEvent
    public void onConnectionCreated(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        Logging.log((String)"SMP: Sync dimensions to client");
        DimensionSyncPacket packet = new DimensionSyncPacket();
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        RfToolsDimensionManager manager = RfToolsDimensionManager.getDimensionManager(player.func_130014_f_());
        for (Integer id : manager.getDimensions().keySet()) {
            Logging.log((String)("Sending over dimension " + id + " to the client"));
            packet.addDimension(id);
        }
        RFToolsDim.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
        RFToolsDim.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(event.getManager().channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
        RFToolsDim.channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        int id = world.field_73011_w.getDimension();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
        if (dimensionInformation != null && dimensionInformation.isNoanimals() && event.getEntity() instanceof IAnimals && !(event.getEntity() instanceof IMob)) {
            event.setCanceled(true);
            Logging.logDebug((String)("Noanimals dimension: Prevented a spawn of " + event.getEntity().getClass().getName()));
        }
    }

    @SubscribeEvent
    public void onEntitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        DimensionStorage storage;
        int energy;
        World world = event.getWorld();
        int id = world.field_73011_w.getDimension();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
        if (PowerConfiguration.preventSpawnUnpowered && dimensionInformation != null && (energy = (storage = DimensionStorage.getDimensionStorage(world)).getEnergyLevel(id)) <= 0) {
            event.setResult(Event.Result.DENY);
            Logging.logDebug((String)("Dimension power low: Prevented a spawn of " + event.getEntity().getClass().getName()));
        }
        if (dimensionInformation != null && (dimensionInformation.hasEffectType(EffectType.EFFECT_STRONGMOBS) || dimensionInformation.hasEffectType(EffectType.EFFECT_BRUTALMOBS)) && event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)event.getEntity();
            IAttributeInstance entityAttribute = entityLivingBase.func_110148_a(SharedMonsterAttributes.field_111267_a);
            double newMax = dimensionInformation.hasEffectType(EffectType.EFFECT_BRUTALMOBS) ? entityAttribute.func_111125_b() * GeneralConfiguration.brutalMobsFactor : entityAttribute.func_111125_b() * GeneralConfiguration.strongMobsFactor;
            entityAttribute.func_111128_a(newMax);
            entityLivingBase.func_70606_j((float)newMax);
        }
        if (event.getEntity() instanceof IMob) {
            BlockPos coordinate = new BlockPos((int)event.getEntity().field_70165_t, (int)event.getEntity().field_70163_u, (int)event.getEntity().field_70161_v);
            if (dimensionInformation != null && dimensionInformation.isPeaceful()) {
                event.setResult(Event.Result.DENY);
                Logging.logDebug((String)("Peaceful dimension: Prevented a spawn of " + event.getEntity().getClass().getName()));
            }
        } else if (event.getEntity() instanceof IAnimals && dimensionInformation != null && dimensionInformation.isNoanimals()) {
            event.setResult(Event.Result.DENY);
            Logging.logDebug((String)("Noanimals dimension: Prevented a spawn of " + event.getEntity().getClass().getName()));
        }
    }

    @SubscribeEvent
    public void onReplaceBiomeBlocks(ChunkGeneratorEvent.ReplaceBiomeBlocks event) {
        World world = event.getWorld();
        if (world == null) {
            return;
        }
        int id = world.field_73011_w.getDimension();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation information = dimensionManager.getDimensionInformation(id);
        if (information != null && information.hasFeatureType(FeatureType.FEATURE_CLEAN)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onOreGenEvent(OreGenEvent.GenerateMinable event) {
        World world = event.getWorld();
        if (world == null) {
            return;
        }
        int id = world.field_73011_w.getDimension();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation information = dimensionManager.getDimensionInformation(id);
        if (information != null && information.hasFeatureType(FeatureType.FEATURE_CLEAN)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof EntityEnderman && this.random.nextFloat() < GeneralConfiguration.endermanDimletPartDrop) {
            event.getDrops().add(new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack((Item)ModItems.dimletParcelItem)));
        }
    }

    @SubscribeEvent
    public void onLootLoad(LootTableLoadEvent event) {
        LootPool main;
        if ((event.getName().equals((Object)LootTableList.field_186424_f) || event.getName().equals((Object)LootTableList.field_186431_m) || event.getName().equals((Object)LootTableList.field_186429_k) || event.getName().equals((Object)LootTableList.field_186430_l) || event.getName().equals((Object)LootTableList.field_186425_g) || event.getName().equals((Object)LootTableList.field_186422_d) || event.getName().equals((Object)LootTableList.field_186423_e)) && (main = event.getTable().getPool("main")) != null) {
            main.addEntry((LootEntry)new LootEntryItem((Item)ModItems.dimletParcelItem, WorldgenConfiguration.dimletParcelRarity, 0, new LootFunction[0], new LootCondition[0], "rftoolsdim:parcel"));
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        RfToolsDimensionManager dimensionManager;
        Block block;
        World world = event.getWorld();
        if (!world.field_72995_K && (block = world.func_180495_p(event.getPos()).func_177230_c()) instanceof BlockBed && (dimensionManager = RfToolsDimensionManager.getDimensionManager(world)).getDimensionInformation(world.field_73011_w.getDimension()) != null) {
            switch (GeneralConfiguration.bedBehaviour) {
                case 0: {
                    event.setCanceled(true);
                    Logging.message((EntityPlayer)event.getEntityPlayer(), (String)"You cannot sleep in this dimension!");
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    event.setCanceled(true);
                    event.getEntityPlayer().setSpawnChunk(event.getPos(), true, event.getWorld().field_73011_w.getDimension());
                    Logging.message((EntityPlayer)event.getEntityPlayer(), (String)"Spawn point set!");
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(LivingSpawnEvent.SpecialSpawn event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving instanceof EntityDragon) {
            int id = world.field_73011_w.getDimension();
            RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
            DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
            if (dimensionInformation != null) {
                NBTTagCompound dragonTag = new NBTTagCompound();
                entityLiving.func_70014_b(dragonTag);
                dragonTag.func_74777_a("DragonPhase", (short)0);
                entityLiving.func_70037_a(dragonTag);
            }
        }
    }
}

